/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska;

import ch.njol.skript.Skript;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONObject;
import uk.co.umbaska.ActiveDevelopmentMode;
import uk.co.umbaska.UmbaskaCommandHandler;
import uk.co.umbaska.UmbaskaConfig;
import uk.co.umbaska.logs.LogLevel;
import uk.co.umbaska.logs.LogUtil;
import uk.co.umbaska.modules.ModuleInfo;
import uk.co.umbaska.modules.ModuleManager;
import uk.co.umbaska.registration.Register;
import uk.co.umbaska.registration.Version;
import uk.co.umbaska.utils.UmbaskaYamlLoadingException;

public class Umbaska
extends JavaPlugin {
    protected static Umbaska i;
    private static CommandSender consoleSender;
    private static LogUtil logUtil;
    private static boolean wasUmbaskaEnabled;
    public static boolean wasServerFullyLoaded;
    private static Logger logger;
    public static File umbaskaJarFile;
    public static final int VERSION_INTEGER = 6;

    public Umbaska() {
        i = this;
    }

    public static Umbaska get() {
        return i;
    }

    public void onEnable() {
        this.reloadConfig();
        logger = Bukkit.getLogger();
        consoleSender = Bukkit.getConsoleSender();
        logUtil = new LogUtil(new File(new File(this.getDataFolder(), "logs"), "latest.log"));
        if (new File(this.getDataFolder(), "umbaskacordconfig.txt").exists()) {
            this.getDataFolder().renameTo(new File(this.getDataFolder().getParentFile(), "Umbaska-2.0-Old-Files-You-Can-Delete-This"));
        }
        if (!this.getDataFolder().exists()) {
            Umbaska.info("Creating directory " + this.getDataFolder().getAbsolutePath());
            this.getDataFolder().mkdir();
        }
        if (Bukkit.getServer().getPluginManager().getPlugin("Skript") == null) {
            Umbaska.error("Whooops! It looks like you don't have Skript on your server.");
            Umbaska.error("You can download it from http://forums.skunity.com/");
            this.setEnabled(false);
            return;
        }
        if (!this.getDescription().getName().equals("Umbaska")) {
            Umbaska.error("The name of this plugin is Umbaska, and it can work only with that name");
            Umbaska.error("Download Umbaska from the official website, umbaska.co.uk");
            this.setEnabled(false);
            return;
        }
        try {
            UmbaskaConfig.loadMainConfig();
        }
        catch (UmbaskaYamlLoadingException e) {
            e.printStackTrace();
            Umbaska.warning("Disabling Umbaska...");
            this.setEnabled(false);
            return;
        }
        if (ModuleManager.prepare()) {
            ModuleManager.loadAndEnableModules();
        }
        Version.checkServerVersion();
        Skript.registerAddon((JavaPlugin)this);
        this.reloadConfig();
        try {
            Register.registerAnnotations();
        }
        catch (Throwable throwable) {
            Umbaska.error("Registering syntaxes failed at some point:");
            throwable.printStackTrace();
            Umbaska.error("Current node: " + Register.currentNode);
            Umbaska.error("Additional info: version: ", this.getDescription().getVersion(), ", debug-mode: ", UmbaskaConfig.debug, ", module-manager-debug-mode: ", UmbaskaConfig.moduleManagerDebug);
            Umbaska.error("Most of things won't work.");
            Umbaska.error("Let me enable the rest of Umbaska..");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (UmbaskaConfig.generateDocs) {
                    Umbaska.logDocsGenerator("Starting to generate the documentation..");
                    File docsDirectory = new File(Umbaska.this.getDataFolder(), "docs");
                    docsDirectory.mkdir();
                    for (Map.Entry<ModuleInfo, JSONObject> entry : Register.moduleJsonDocsMap.entrySet()) {
                        String moduleName = entry.getKey().getName();
                        String loopStringJson = entry.getValue().toString();
                        Umbaska.logDocsGenerator("Generating documentation for a module with name ", moduleName);
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        JsonParser parser = new JsonParser();
                        JsonObject o = parser.parse(loopStringJson).getAsJsonObject();
                        String json = gson.toJson(o);
                        File docFile = new File(docsDirectory, moduleName + "-doc.json");
                        if (!docFile.exists()) {
                            try {
                                docFile.createNewFile();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            FileOutputStream fos = new FileOutputStream(docFile);
                            Throwable throwable = null;
                            try {
                                OutputStreamWriter osw = new OutputStreamWriter(fos);
                                Throwable throwable2 = null;
                                try {
                                    osw.write(json);
                                    osw.flush();
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (osw == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            osw.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    osw.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (fos == null) continue;
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                fos.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    Umbaska.logDocsGenerator("The documentation has been successfully generated.");
                }
            }
        });
        UmbaskaCommandHandler handler = new UmbaskaCommandHandler();
        this.getCommand("umbaska").setExecutor((CommandExecutor)handler);
        this.getCommand("executeskriptcommand").setExecutor((CommandExecutor)handler);
        if (UmbaskaConfig.activeDevelopmentMode) {
            ActiveDevelopmentMode.start(UmbaskaConfig.activeDevelopmentCommand);
        }
        wasUmbaskaEnabled = true;
        logUtil.flush();
        Bukkit.getScheduler().runTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                wasServerFullyLoaded = true;
            }
        });
    }

    public void onDisable() {
        ModuleManager.disableModules();
    }

    public static void printStackTraceIfDebug(Throwable throwable) {
        if (UmbaskaConfig.debug) {
            throwable.printStackTrace();
        }
    }

    public static void info(Object ... toLog) {
        Umbaska.log(LogLevel.INFO, toLog);
    }

    public static void debug(Object ... toLog) {
        Umbaska.log(LogLevel.DEBUG, toLog);
    }

    public static void debug(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(LogLevel.DEBUG, clazz, toLog);
    }

    public static void logDocsGenerator(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(LogLevel.DOCS, clazz, toLog);
    }

    public static void logDocsGenerator(Object ... toLog) {
        Umbaska.log(LogLevel.DOCS, toLog);
    }

    public static void error(Object ... toLog) {
        Umbaska.log(LogLevel.ERROR, toLog);
    }

    public static void error(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(LogLevel.ERROR, clazz, toLog);
    }

    public static void fail(Object ... toLog) {
        Umbaska.log(LogLevel.FAIL, toLog);
    }

    public static void fail(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(LogLevel.FAIL, clazz, toLog);
    }

    public static void moduleManagerInfo(Object ... toLog) {
        Umbaska.log(LogLevel.MODULE_MANAGER, toLog);
    }

    public static void moduleManagerWarning(Object ... toLog) {
        Umbaska.log(LogLevel.MODULE_MANAGER_WARNING, toLog);
    }

    public static void moduleManagerError(Object ... toLog) {
        Umbaska.log(LogLevel.MODULE_MANAGER_ERROR, toLog);
    }

    public static void moduleManagerDebug(Object ... toLog) {
        Umbaska.log(LogLevel.MODULE_MANAGER_DEBUG, toLog);
    }

    public static void updater(Object ... toLog) {
        Umbaska.log(LogLevel.UPDATER, toLog);
    }

    public static void warning(Object ... toLog) {
        Umbaska.log(LogLevel.WARNING, toLog);
    }

    public void toFile(Object ... toLog) {
        Umbaska.log(LogLevel.FILE_ONLY, null, toLog);
    }

    public static void log(LogLevel level, Class<?> clazz, Object ... toLog) {
        if (clazz == null) {
            Umbaska.log(level, toLog);
            return;
        }
        Umbaska.log(level, "[", clazz.getCanonicalName(), "] ", StringUtils.join((Object[])toLog));
    }

    public static void log(@Nullable LogLevel level, Object ... toLog) {
        if (toLog == null) {
            toLog = new String[]{""};
        }
        if (level == null) {
            level = LogLevel.INFO;
        }
        StringBuilder builder = new StringBuilder("[Umbaska");
        Level bukkitLevel = Level.INFO;
        String toAppend = null;
        switch (level) {
            case MODULE_MANAGER: 
            case MODULE_MANAGER_DEBUG: {
                builder.append(" Module Manager");
                break;
            }
            case MODULE_MANAGER_WARNING: {
                bukkitLevel = Level.WARNING;
                builder.append(" Module Manager");
                break;
            }
            case MODULE_MANAGER_ERROR: {
                bukkitLevel = Level.SEVERE;
                builder.append(" Module Manager");
                break;
            }
            case INFO: {
                break;
            }
            case FAIL: {
                toAppend = "[Fail] ";
                bukkitLevel = Level.WARNING;
                break;
            }
            case WARNING: {
                bukkitLevel = Level.WARNING;
                break;
            }
            case ERROR: {
                bukkitLevel = Level.SEVERE;
                break;
            }
            case DEBUG: {
                break;
            }
            case UPDATER: {
                toAppend = "[Updater] ";
                break;
            }
            case DOCS: {
                toAppend = "[Docs] ";
                break;
            }
        }
        builder.append("] ");
        if (toAppend != null) {
            builder.append(toAppend);
        }
        for (Object o : toLog) {
            if (o == null) continue;
            if (o instanceof String) {
                builder.append(o);
                continue;
            }
            if (o instanceof String[]) {
                String[] k;
                for (String l : k = (String[])o) {
                    builder.append(l);
                }
                continue;
            }
            builder.append(o.toString());
        }
        String end = builder.toString();
        if ((level != LogLevel.DEBUG && level != LogLevel.MODULE_MANAGER_DEBUG || UmbaskaConfig.debug) && level != LogLevel.FILE_ONLY) {
            if (logger != null) {
                logger.log(bukkitLevel, end);
            } else if (consoleSender != null) {
                consoleSender.sendMessage(end);
            } else {
                System.out.println(end);
            }
        }
        try {
            logUtil.log(end);
        }
        catch (Exception e) {
            return;
        }
        if (wasUmbaskaEnabled) {
            logUtil.flush();
        }
    }

    public String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public String[] color(String ... ss) {
        int i = 0;
        for (String s : ss) {
            ss[i] = this.color(s);
            ++i;
        }
        return ss;
    }

    static {
        wasUmbaskaEnabled = false;
        wasServerFullyLoaded = false;
        umbaskaJarFile = new File(Umbaska.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        try {
            umbaskaJarFile = new File(Umbaska.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

