/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.access.utils;

import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.co.umbaska.Umbaska;

public class HttpExchangeUtility {
    public static Map<String, String> getGETVariables(HttpExchange exchange) {
        return HttpExchangeUtility.getGETVariables(exchange.getRequestURI().getQuery());
    }

    public static Map<String, String> getGETVariables(String query) {
        if (query == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
                continue;
            }
            result.put(pair[0], "");
        }
        return result;
    }

    public static Map<String, Object> getPOSTVariables(HttpExchange exchange) {
        if (!(exchange.getAttribute("parameters") instanceof Map)) {
            Umbaska.fail((Object[])new Object[]{"You may not get post variables from a non event-handler (which originated from EffNewWebServer) exchange"});
            return null;
        }
        return (Map)exchange.getAttribute("parameters");
    }

    public static class ParameterFilter
    extends Filter {
        @Override
        public String description() {
            return "Parses the requested URI for parameters";
        }

        @Override
        public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
            this.parseGetParameters(exchange);
            this.parsePostParameters(exchange);
            chain.doFilter(exchange);
        }

        private void parseGetParameters(HttpExchange exchange) throws UnsupportedEncodingException {
            HashMap parameters = new HashMap();
            URI requestedUri = exchange.getRequestURI();
            String query = requestedUri.getRawQuery();
            this.parseQuery(query, parameters);
            exchange.setAttribute("parameters", parameters);
        }

        private void parsePostParameters(HttpExchange exchange) throws IOException {
            if ("post".equalsIgnoreCase(exchange.getRequestMethod())) {
                Map parameters = (Map)exchange.getAttribute("parameters");
                InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String query = br.readLine();
                this.parseQuery(query, parameters);
            }
        }

        private void parseQuery(String query, Map parameters) throws UnsupportedEncodingException {
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("[&]")) {
                    String[] param = pair.split("[=]");
                    String key = null;
                    String value = null;
                    if (param.length > 0) {
                        key = URLDecoder.decode(param[0], System.getProperty("file.encoding"));
                    }
                    if (param.length > 1) {
                        value = URLDecoder.decode(param[1], System.getProperty("file.encoding"));
                    }
                    if (parameters.containsKey(key)) {
                        ArrayList<String> values;
                        Object obj = parameters.get(key);
                        if (obj instanceof List) {
                            values = (ArrayList<String>)obj;
                            values.add(value);
                            continue;
                        }
                        if (!(obj instanceof String)) continue;
                        values = new ArrayList<String>();
                        values.add((String)obj);
                        values.add(value);
                        parameters.put(key, values);
                        continue;
                    }
                    parameters.put(key, value);
                }
            }
        }
    }
}

