/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.access.skript.webserver.types;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.access.skript.webserver.HTTPServerManager;
import uk.co.umbaska.modules.access.skript.webserver.types.UmbaskaHttpHandler;

public final class HTTPServer {
    private HttpServer server;
    private Integer port;
    private Boolean executorStarted;
    private UmbaskaHttpHandler handler;
    private HttpContext currentContext;

    public HTTPServer(Integer port) throws HTTPServerManager.PortInUseException {
        try {
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            this.port = port;
        }
        catch (BindException e) {
            throw new HTTPServerManager.PortInUseException(port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HttpServer getServer() {
        return this.server;
    }

    public void setExecutor() {
        this.server.setExecutor(null);
        this.executorStarted = true;
    }

    public void startServerForFirstTime() {
        this.setExecutor();
        this.startServer();
    }

    public void startServer() {
        if (!this.executorStarted.booleanValue()) {
            Umbaska.info((Object[])new Object[]{"Forced the starting of the Executor!"});
            this.setExecutor();
            this.executorStarted = true;
        }
        this.server.start();
    }

    public void stopServer() {
        this.server.stop(this.port);
    }

    public HttpContext createContext(String uri, HttpHandler handler) {
        return this.server.createContext(uri, handler);
    }

    public void removeContext(String uri) {
        this.server.removeContext(uri);
    }

    public void removeContext(HttpContext context) {
        this.server.removeContext(context);
    }

    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    public Integer getRegisteredPort() {
        return this.server.getAddress().getPort();
    }

    public Integer getGivenPort() {
        return this.port;
    }

    public String getFullAddress() {
        String address = this.getAddress().getHostString();
        String port = this.getRegisteredPort().toString();
        return address + ":" + port;
    }

    public UmbaskaHttpHandler getHandler() {
        return this.handler;
    }

    public void setHandler(UmbaskaHttpHandler handler) {
        try {
            this.server.removeContext("/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentContext = this.server.createContext("/", handler);
        this.handler = handler;
    }

    public HttpContext getCurrentContext() {
        return this.currentContext;
    }
}

