/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.access.skript.webserver.handlers;

import com.sun.net.httpserver.HttpExchange;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import uk.co.umbaska.modules.access.skript.webserver.types.UmbaskaHttpHandler;

public class FileWebHandler
extends UmbaskaHttpHandler {
    File directory;
    private OutputStreamWriter out;

    public FileWebHandler(File directory) {
        super(null);
        assert (directory.isDirectory());
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String path = httpExchange.getRequestURI().getPath();
        System.out.println("HANDLING: " + path);
        this.out = new OutputStreamWriter(httpExchange.getResponseBody(), "UTF-8");
        if (path.contains("../")) {
            path.replace("../", "");
        }
        File requested = new File(this.directory.getAbsolutePath() + path);
        System.out.println("REQUESTED FILE: " + requested.getAbsolutePath());
        if (!requested.exists()) {
            System.out.println("404");
            String string = "Could not find " + path + " on this server!";
            httpExchange.sendResponseHeaders(400, 0L);
            this.out.write(string);
            this.out.close();
            httpExchange.close();
        }
        if (path.equals("/") && requested.isDirectory()) {
            for (File file : requested.listFiles()) {
                if (!FilenameUtils.getBaseName((String)file.getAbsolutePath()).equals("index")) continue;
                requested = file;
            }
        }
        if (FilenameUtils.getExtension((String)requested.getAbsolutePath()).equals("")) {
            httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
        } else {
            Path path2 = requested.toPath();
            String contentType = Files.probeContentType(path2);
            if (contentType != null) {
                System.out.println("CT: " + contentType);
                httpExchange.getResponseHeaders().set("Content-Type", contentType);
            }
        }
        String string = FileUtils.readFileToString((File)requested);
        httpExchange.sendResponseHeaders(200, 0L);
        System.out.println("RESPONSE SENDING: " + string);
        this.out.write(string);
        this.out.close();
        httpExchange.close();
    }
}

