/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.access.skript.webserver.effects;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sun.net.httpserver.HttpContext;
import org.bukkit.event.Event;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.access.skript.webserver.HTTPServerManager;
import uk.co.umbaska.modules.access.skript.webserver.handlers.EventWebHandler;
import uk.co.umbaska.modules.access.skript.webserver.types.HTTPServer;
import uk.co.umbaska.modules.access.utils.HttpExchangeUtility;
import uk.co.umbaska.registration.UmbaskaEffect;
import uk.co.umbaska.registration.annotations.Name;
import uk.co.umbaska.registration.annotations.Syntaxes;

@Name(value="Start a New Web Server")
@Syntaxes(value={"start (http|web|website) [server ]on port %integer%", "start (http|web|website) [server ]on port %integer% if not already started"})
public class EffNewWebServer
extends UmbaskaEffect {
    Expression<Integer> port;
    Boolean ifAlreadyStartedCheck = false;

    protected void execute(Event event) {
        Integer port = (Integer)this.port.getSingle(event);
        if (port == null) {
            return;
        }
        try {
            if (this.ifAlreadyStartedCheck.booleanValue() && HTTPServerManager.portInUse(port).booleanValue()) {
                return;
            }
            HTTPServer httpServer = HTTPServerManager.create(port);
            httpServer.setHandler(new EventWebHandler(httpServer));
            HttpContext defaultContext = httpServer.getCurrentContext();
            defaultContext.getFilters().add(new HttpExchangeUtility.ParameterFilter());
            httpServer.startServerForFirstTime();
        }
        catch (HTTPServerManager.PortInUseException e) {
            Umbaska.error((Object[])new Object[]{"Port " + e.getPort() + " is already in use! Add \"if not already started\" to the syntax."});
        }
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.port = expressions[0];
        this.ifAlreadyStartedCheck = i == 1;
        return true;
    }
}

