/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.access.skript.webserver;

import java.util.HashMap;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.access.skript.webserver.types.HTTPServer;

public class HTTPServerManager {
    private static HashMap<Integer, HTTPServer> servers = new HashMap();

    public static HTTPServer create(Integer port) throws PortInUseException {
        assert (port != null) : "Port must not be null";
        if (servers.keySet().contains(port)) {
            throw new PortInUseException(port);
        }
        HTTPServer server = new HTTPServer(port);
        Umbaska.info((Object[])new Object[]{"Started HTTPServer on port " + port});
        servers.put(port, server);
        return server;
    }

    public static Boolean portInUse(Integer i) {
        return servers.containsKey(i);
    }

    public static HTTPServer getFromPort(int port) {
        return servers.get(port);
    }

    public static class PortInUseException
    extends Exception {
        Integer port;

        public PortInUseException(Integer port) {
            super("Port in use: " + Integer.toString(port));
            this.port = port;
        }

        public Integer getPort() {
            return this.port;
        }
    }
}

