/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.access.skript.mysql.types;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import uk.co.umbaska.Umbaska;

public class UmbaskaSQLConnection {
    public static HashMap<String, UmbaskaSQLConnection> connections = new HashMap();
    private final String host;
    private final String database;
    private final String user;
    private final String password;
    private final String connectionName;
    private Connection connection;

    public UmbaskaSQLConnection(String host, String database, String user, String password, String connectionName) {
        this.host = host;
        this.database = database;
        this.user = user;
        this.password = password;
        this.connectionName = connectionName;
        if (connections.containsKey(connectionName)) {
            return;
        }
        this.connect();
        connections.put(connectionName, this);
    }

    public void connect() {
        try {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":3306/" + this.database + "?autoReconnect=true", this.user, this.password);
            Umbaska.info((Object[])new Object[]{" [UmbAccess] The connection to MySQL is made for the key " + this.connectionName + "!"});
        }
        catch (SQLException e) {
            Umbaska.fail((Object[])new Object[]{" [UmbAccess] The connection to MySQL couldn't be made for the key " + this.connectionName + "! reason: " + e.getMessage()});
        }
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
                Umbaska.info((Object[])new Object[]{" [UmbAccess] The connection to MySQL for the key " + this.connectionName + " has ended successfully!"});
            }
        }
        catch (SQLException e) {
            Umbaska.fail((Object[])new Object[]{" [UmbAccess] Could not close connection for the key " + this.connectionName});
            e.printStackTrace();
        }
    }

    public PreparedStatement prepareStatement(String qry) {
        try {
            if (!this.hasConnection() || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PreparedStatement st = null;
        try {
            st = this.connection.prepareStatement(qry);
        }
        catch (SQLException e) {
            Umbaska.fail((Object[])new Object[]{" [UmbAccess] Could not create a prepared statement for \"" + qry + "\" for the key " + this.connectionName});
            e.printStackTrace();
        }
        return st;
    }

    public void update(PreparedStatement statement) {
        try {
            if (!this.hasConnection() || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.connect();
            e.printStackTrace();
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public ResultSet query(PreparedStatement statement) {
        try {
            if (!this.hasConnection() || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            return statement.executeQuery();
        }
        catch (SQLException e) {
            this.connect();
            e.printStackTrace();
            return null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

