/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.teams.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import uk.co.umbaska.modules.teams.Teams;
import uk.co.umbaska.modules.teams.types.Permission;
import uk.co.umbaska.modules.teams.types.Team;
import uk.co.umbaska.modules.teams.utils.Event;

public class TeamManager {
    private List<Permission> globalPermissions = new ArrayList<Permission>();
    private List<Team> teams = new ArrayList<Team>();
    private List<Team> autoJoinTeams = new ArrayList<Team>();
    private HashMap<Player, Team> playerMainTeams = new HashMap();

    public TeamManager() {
        this.registerEvents();
    }

    public Team createTeam(String name) {
        Team t = new Team(name);
        if (!this.teams.contains(t)) {
            this.teams.add(t);
        }
        return new Team(name);
    }

    public void saveTeam(Team t) {
        int i;
        for (i = 0; i < this.teams.size(); ++i) {
            if (this.teams.get(i).getName() != t.getName()) continue;
            this.teams.set(i, t);
        }
        if (this.autoJoinTeams.contains(t)) {
            for (i = 0; i < this.autoJoinTeams.size(); ++i) {
                if (this.autoJoinTeams.get(i).getName() != t.getName()) continue;
                this.autoJoinTeams.set(i, t);
            }
        }
        if (this.playerMainTeams.containsValue(t)) {
            for (Player p : this.playerMainTeams.keySet()) {
                if (this.playerMainTeams.get(p).getName() != t.getName()) continue;
                this.playerMainTeams.remove(p);
                this.playerMainTeams.put(p, t);
            }
        }
    }

    public void deleteTeam(Object team) {
        Team t = this.getTeam(team);
        if (t == null) {
            return;
        }
        if (this.teams.contains(t)) {
            this.teams.remove(t);
            if (this.autoJoinTeams.contains(t)) {
                this.autoJoinTeams.remove(t);
            }
            if (this.playerMainTeams.containsValue(t)) {
                for (Player p : this.playerMainTeams.keySet()) {
                    if (this.playerMainTeams.get(p).getName() != t.getName()) continue;
                    this.playerMainTeams.remove(p);
                }
            }
        }
    }

    public void addAutoJoinTeam(Object team) {
        Team t = this.getTeam(team);
        if (t == null) {
            return;
        }
        if (!this.autoJoinTeams.contains(t)) {
            this.autoJoinTeams.add(t);
        }
    }

    public void removeAutoJoinTeam(Object team) {
        Team t = this.getTeam(team);
        if (t == null) {
            return;
        }
        if (this.autoJoinTeams.contains(t)) {
            this.autoJoinTeams.remove(t);
        }
    }

    public List<Team> getAutoJoinTeams() {
        return this.autoJoinTeams;
    }

    public HashMap<Player, Team> getMainTeams() {
        return this.playerMainTeams;
    }

    public Team getMainPlayerTeam(Player p) {
        if (this.playerMainTeams.containsKey(p)) {
            return this.playerMainTeams.get(p);
        }
        return null;
    }

    public void setMainPlayerTeam(Player p, Team t) {
        this.playerMainTeams.put(p, t);
    }

    public void removeMainPlayerTeam(Player p) {
        this.playerMainTeams.remove(p);
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public Team getTeam(Object team) {
        if (team instanceof Team) {
            return (Team)team;
        }
        if (team instanceof String) {
            for (Team t : this.teams) {
                if (!t.getName().equalsIgnoreCase((String)team)) continue;
                return t;
            }
        }
        return null;
    }

    public List<Team> getTeamsOfPlayer(Player p) {
        ArrayList<Team> teams = new ArrayList<Team>();
        for (Team t : this.teams) {
            if (!t.getMembers().contains(p)) continue;
            teams.add(t);
        }
        return teams;
    }

    public List<Permission> getGlobalPermissions() {
        return this.globalPermissions;
    }

    public void registerDefaultGlobalPermissions() {
        new Permission("chat", true).register();
        new Permission("block break", true).register();
        new Permission("command", true).register();
    }

    public void registerGlobalPermission(Permission p) {
        if (!this.globalPermissions.contains(p)) {
            this.globalPermissions.add(p);
        }
    }

    public void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new Event(), (Plugin)Teams.getInstance().getUmbaska());
    }
}

