/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.teams.utils;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import uk.co.umbaska.modules.teams.Teams;
import uk.co.umbaska.modules.teams.types.Permission;
import uk.co.umbaska.modules.teams.types.Team;

public class Event
implements Listener {
    public Boolean handleEvent(Object playerObject, String permissionName) {
        Player p = null;
        if (!(playerObject instanceof Player)) {
            return false;
        }
        p = (Player)playerObject;
        Team team = Teams.getTeamManager().getMainPlayerTeam(p);
        if (team == null) {
            return false;
        }
        Permission permission = team.getPermissionByName(permissionName);
        if (permission == null) {
            return false;
        }
        return permission.getValue();
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        event.setCancelled(this.handleEvent(event.getPlayer(), "chat").booleanValue());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        event.setCancelled(this.handleEvent(event.getPlayer(), "block break").booleanValue());
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        event.setCancelled(this.handleEvent(event.getPlayer(), "command").booleanValue());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (Teams.getTeamManager().getAutoJoinTeams() != null && Teams.getTeamManager().getAutoJoinTeams().size() > 0) {
            Player p = event.getPlayer();
            for (Team t : Teams.getTeamManager().getAutoJoinTeams()) {
                t.addPlayer(p);
            }
        }
    }
}

