/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.teams.types;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import uk.co.umbaska.modules.teams.Teams;
import uk.co.umbaska.modules.teams.types.Permission;

public class Team {
    private List<Permission> teamPermissions = new ArrayList<Permission>();
    private String name;
    private List<Player> teamMembers = new ArrayList<Player>();
    private Player teamLeader;

    public Team(String name) {
        this.name = name;
        this.registerDefaultPermissions();
    }

    public void save() {
        Teams.getTeamManager().saveTeam(this);
    }

    public void addPlayer(Player p) {
        if (!this.teamMembers.contains(p)) {
            if (Teams.getTeamManager().getMainPlayerTeam(p) == null) {
                Teams.getTeamManager().setMainPlayerTeam(p, this);
            }
            this.teamMembers.add(p);
        }
    }

    public void removePlayer(Player p) {
        if (this.teamMembers.contains(p)) {
            Teams.getTeamManager().removeMainPlayerTeam(p);
            this.teamMembers.remove(p);
        }
    }

    public void setLeader(Player p) {
        if (this.teamMembers.contains(p)) {
            this.teamLeader = p;
        }
    }

    public Player getLeader(Player p) {
        return this.teamLeader;
    }

    public String getName() {
        return this.name;
    }

    public List<Permission> getPermissions() {
        return this.teamPermissions;
    }

    public Permission getPermissionByName(String name) {
        for (Permission p : this.teamPermissions) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public List<Player> getMembers() {
        return this.teamMembers;
    }

    public void registerPermission(String name, Boolean value) {
        Permission p = new Permission(name, value);
        this.registerPermission(p);
    }

    public void registerPermission(Permission p) {
        if (!this.teamPermissions.contains(p)) {
            this.teamPermissions.add(p);
        }
    }

    public void registerDefaultPermissions() {
        for (Permission p : Teams.getTeamManager().getGlobalPermissions()) {
            this.registerPermission(p.getName(), p.getValue());
        }
    }
}

