/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.teams.conditions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import uk.co.umbaska.modules.teams.Teams;
import uk.co.umbaska.modules.teams.types.Team;
import uk.co.umbaska.registration.UmbaskaCondition;
import uk.co.umbaska.registration.annotations.Name;
import uk.co.umbaska.registration.annotations.Syntaxes;

@Name(value="Teams - player is in team")
@Syntaxes(value={"%player% is (in|already in|[a] memebr of) team %string%", "%player% isn't (in|already in|[a] memebr of) team %string%"})
public class CondInTeam
extends UmbaskaCondition {
    private Expression<Player> eventPlayer;
    private Expression<Object> eventTeam;
    private int matchType;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.matchType = i;
        this.eventPlayer = expressions[0];
        this.eventTeam = expressions[1];
        return true;
    }

    public boolean doReturn(boolean bool) {
        if (this.matchType == 0) {
            return bool;
        }
        return !bool;
    }

    public boolean check(Event event) {
        Player player = (Player)this.eventPlayer.getSingle(event);
        Team team = Teams.getTeamManager().getTeam(this.eventTeam.getSingle(event));
        if (player == null || team == null) {
            return this.doReturn(false);
        }
        List<Team> allTeams = Teams.getTeamManager().getTeamsOfPlayer(player);
        return this.doReturn(allTeams.contains(team));
    }
}

