/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.particles.projectiles.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import uk.co.umbaska.modules.particles.ParticleModule;
import uk.co.umbaska.modules.particles.projectiles.ParticleProjectile;
import uk.co.umbaska.modules.particles.utils.ParticleError;
import uk.co.umbaska.registration.UmbaskaEffect;
import uk.co.umbaska.registration.annotations.Name;
import uk.co.umbaska.registration.annotations.Syntaxes;

@Name(value="Particle Projectile - Shoot a projectile")
@Syntaxes(value={"(force|make) %entity% shoot particle projectile %string% with speed %number%"})
public class EffMakeShootParticleProjectile
extends UmbaskaEffect {
    private Expression<Entity> shooter;
    private Expression<String> name;
    private Expression<Number> speed;

    protected void execute(Event event) {
        if (ParticleModule.particleProjectiles().containsKey(this.name.getSingle(event))) {
            ParticleProjectile particleProjectile = ParticleModule.particleProjectiles().get(this.name.getSingle(event));
            Vector v = EffMakeShootParticleProjectile.getDirection(((Entity)this.shooter.getSingle(event)).getLocation().getYaw(), ((Entity)this.shooter.getSingle(event)).getLocation().getPitch());
            particleProjectile.setVector(v.multiply(((Number)this.speed.getSingle(event)).doubleValue()));
            try {
                particleProjectile.start();
            }
            catch (ParticleError e) {
                e.printStackTrace();
            }
        } else {
            Skript.error((String)(Skript.SKRIPT_PREFIX + "Particle Projectile doesn't exist"));
        }
    }

    public static Vector getDirection(float yaw, float pitch) {
        Vector vector = new Vector();
        double rotX = (float)Math.PI / 180 * yaw;
        double rotY = (float)Math.PI / 180 * pitch;
        vector.setY(-Math.sin(rotY));
        double h = Math.cos(rotY);
        vector.setX(-h * Math.sin(rotX));
        vector.setZ(h * Math.cos(rotX));
        return vector;
    }

    public String toString(Event event, boolean b) {
        return "Start Particle Projectile";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.name = expressions[1];
        this.shooter = expressions[0];
        this.speed = expressions[2];
        return true;
    }
}

