/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.particles.fancyeffects;

import java.util.HashMap;
import java.util.Map;

public enum FancyEffectType {
    ARC(1, "arc"),
    ATOM(2, "atom"),
    BAND(3, "band"),
    BLOOD_HELIX(4, "blood helix"),
    BREATH(5, "breath"),
    CAPE(6, "cape"),
    COLOR_IMAGE(7, "image"),
    CIRCLE(8, "circle"),
    CONE(9, "cone"),
    CYLINDER(10, "cylinder"),
    DISCO(11, "disco"),
    HALO(12, "halo"),
    HEART(13, "heart"),
    LINE(14, "line"),
    NYANCAT(15, "nyan cat"),
    PLANET(16, "planet"),
    RINGS(17, "rings"),
    SPHERE(18, "sphere"),
    SPIRAL(19, "spiral"),
    TEXT(20, "text"),
    WARP_RINGS(21, "warp rings"),
    WINGS(22, "wings"),
    CIRCLE2(99, "circle2"),
    ITEM_FOUNTAIN(23, "item fountain"),
    PLACEHOLDER(0, "placeholder");

    public static final Map<Integer, FancyEffectType> ID_MAP;
    public static final Map<String, FancyEffectType> NAME_MAP;
    private final Integer id;
    private final String name;

    private FancyEffectType(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Integer getId() {
        return this.id;
    }

    public static FancyEffectType fromId(Integer id) {
        for (Map.Entry<Integer, FancyEffectType> entry : ID_MAP.entrySet()) {
            if (entry.getKey() != id) continue;
            return entry.getValue();
        }
        return null;
    }

    public static FancyEffectType fromName(String name) {
        for (Map.Entry<String, FancyEffectType> entry : NAME_MAP.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        ID_MAP = new HashMap<Integer, FancyEffectType>();
        NAME_MAP = new HashMap<String, FancyEffectType>();
        for (FancyEffectType effect : FancyEffectType.values()) {
            ID_MAP.put(effect.id, effect);
            NAME_MAP.put(effect.name, effect);
        }
    }
}

