/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.particles.fancyeffects;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.modules.particles.fancyeffects.FancyEffect;
import uk.co.umbaska.modules.particles.utils.ParticleError;

public abstract class FancyEffectCore {
    protected double PI = Math.PI;
    protected double PI2 = Math.PI * 2;
    protected double degreesToRadians = this.PI / 180.0;
    Boolean running = false;
    Boolean paused = false;
    Boolean pausedInPlace = false;
    Tracker tracker;
    protected FancyEffect effect = new FancyEffect();

    public boolean isRunning() {
        return this.running;
    }

    public FancyEffect getEffect() {
        return this.effect;
    }

    public void setEffect(FancyEffect effect) {
        this.effect = effect;
    }

    public void start() throws ParticleError {
        if (this.effect.currentDynLocation == null) {
            throw new ParticleError("Location not provided");
        }
        if (this.isRunning()) {
            throw new ParticleError("Already running");
        }
        this.running = true;
        this.effect.currentDynLocation = this.effect.getStartDynLocation();
        this.tracker = new Tracker();
        this.tracker.run();
    }

    public void stop() {
        this.running = false;
        this.tracker.task.cancel();
    }

    public void pause() {
        if (this.isRunning()) {
            this.paused = true;
            this.pausedInPlace = false;
        }
    }

    public void unpause() {
        if (this.isRunning()) {
            this.paused = false;
            this.pausedInPlace = false;
        }
    }

    public void pause(boolean inPlace) {
        if (this.isRunning()) {
            this.paused = true;
            this.pausedInPlace = inPlace;
        }
    }

    public abstract void onRun();

    public void spawnParticle() {
        this.effect.getParticle().display((Integer)this.effect.getCount(), this.effect.getParticleMaterial(), (byte)this.effect.getParticleMaterial().getId(), this.effect.getParticleSpeed(), this.effect.getXoff(), this.effect.getYoff(), this.effect.getZoff(), new Location[]{this.effect.getCurrentDynLocation()}, this.effect.getVisibleRange(), null);
    }

    public void spawnParticle(Vector vector) {
        this.effect.getCurrentDynLocation().add(vector);
        this.effect.getParticle().display((Integer)this.effect.getCount(), this.effect.getParticleMaterial(), (byte)this.effect.getParticleMaterial().getId(), this.effect.getParticleSpeed(), this.effect.getXoff(), this.effect.getYoff(), this.effect.getZoff(), new Location[]{this.effect.getCurrentDynLocation()}, this.effect.getVisibleRange(), null);
    }

    public void spawnParticle(List<Vector> vectors) {
        for (Vector vector : vectors) {
            this.spawnParticle(vector);
        }
    }

    public double wrapAngleRad(double angle) {
        if ((angle %= this.PI2) <= -this.PI) {
            return angle + this.PI2;
        }
        if (angle > this.PI) {
            return angle - this.PI2;
        }
        return angle;
    }

    class Tracker
    implements Runnable {
        BukkitTask task;

        public Tracker() {
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)Umbaska.get(), (Runnable)this, 0L, (long)FancyEffectCore.this.effect.getTickDelay());
        }

        @Override
        public void run() {
            if (FancyEffectCore.this.isRunning()) {
                if (!FancyEffectCore.this.paused.booleanValue()) {
                    FancyEffectCore.this.onRun();
                } else if (FancyEffectCore.this.pausedInPlace.booleanValue()) {
                    FancyEffectCore.this.spawnParticle();
                }
            }
        }
    }
}

