/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.misc.yaml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLManager {
    private FileConfiguration fileConfig;
    private Object mainFile;

    public YAMLManager(Object file) {
        this.fileConfig = this.toFileConfig(file);
        this.mainFile = file;
    }

    public Boolean isUsable() {
        if (this.fileConfig == null || this.mainFile == null) {
            return false;
        }
        return true;
    }

    public FileConfiguration getFileConfig() {
        return this.fileConfig;
    }

    public Object getMainFile() {
        return this.mainFile;
    }

    @Deprecated
    public Object getYAMLValue(String path) {
        return this.getValue(path);
    }

    public Object getValue(String path) {
        if (this.fileConfig == null) {
            return null;
        }
        return this.fileConfig.get(path);
    }

    public Set<String> getKeys(Boolean depth) {
        if (this.fileConfig == null) {
            return null;
        }
        return this.fileConfig.getKeys(depth.booleanValue());
    }

    public List<?> getList(String path) {
        if (this.fileConfig == null) {
            return null;
        }
        return this.fileConfig.getList(path);
    }

    public Object getValue(String path, Class<?> classType) {
        if (this.fileConfig == null) {
            return null;
        }
        if (this.isOfClass(this.fileConfig.get(path), classType).booleanValue()) {
            return this.fileConfig.get(path);
        }
        return null;
    }

    public ConfigurationSection getConfigSection(String path) {
        if (this.fileConfig.getConfigurationSection(path) == null) {
            return null;
        }
        return this.fileConfig.getConfigurationSection(path);
    }

    public Set<String> getSectionKeys(ConfigurationSection section, Boolean goDeep) {
        if (section == null) {
            return null;
        }
        return section.getKeys(goDeep.booleanValue());
    }

    public Boolean isOfClass(Object inputData, Class<?> classType) {
        if (inputData.getClass().equals(classType)) {
            return true;
        }
        return false;
    }

    public Boolean isOfClass(Object inputData, Object classType) {
        if (inputData.getClass().equals(classType.getClass())) {
            return true;
        }
        return false;
    }

    public FileConfiguration toFileConfig(Object file) {
        File yamlFile;
        if (file.getClass().equals(String.class)) {
            File yamlFile2 = new File((String)file);
            if (this.createIfNotExists(yamlFile2, true).booleanValue()) {
                return YamlConfiguration.loadConfiguration((File)yamlFile2);
            }
        } else if (file.getClass().equals(File.class) && this.createIfNotExists(yamlFile = (File)file, true).booleanValue()) {
            return YamlConfiguration.loadConfiguration((File)yamlFile);
        }
        return null;
    }

    public Boolean createIfNotExists(File file, Boolean mkdirs) {
        if (file.exists()) {
            return true;
        }
        if (mkdirs.booleanValue()) {
            file.mkdirs();
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteYAMLValue(String path) {
        this.writeYAMLValue(path, null);
    }

    public void writeYAMLValue(String path, Object value) {
        if (this.fileConfig == null) {
            return;
        }
        this.fileConfig.set(path, value);
        this.saveYAML();
    }

    public void saveYAML() {
        if (this.mainFile.getClass().equals(String.class)) {
            try {
                this.fileConfig.save((String)this.mainFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.mainFile.getClass().equals(File.class)) {
            try {
                this.fileConfig.save((File)this.mainFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

