/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.modules.misc.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import java.util.concurrent.TimeUnit;
import org.bukkit.event.Event;
import uk.co.umbaska.registration.SimpleUmbaskaExpression;
import uk.co.umbaska.registration.annotations.Name;
import uk.co.umbaska.registration.annotations.Syntaxes;
import uk.co.umbaska.stats.Stats;

@Name(value="Timespan converted to different units")
@Syntaxes(value={"%timespan% converted to milliseconds", "%timespan% converted to seconds", "%timespan% converted to minutes", "%timespan% converted to hours", "%timespan% converted to days", "%timespan% converted to ticks", "%timespan% converted to (minecraft|mc) minutes", "%timespan% converted to (minecraft|mc) hours", "%timespan% converted to (minecraft|mc) days"})
public class ExprTimeSpanToUnits
extends SimpleUmbaskaExpression<Long> {
    private Expression<Timespan> timespan;
    private int mode;

    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.timespan = expressions[0];
        this.mode = i;
        return Stats.initTrue((Object)((Object)this));
    }

    protected Long[] get(Event event) {
        Timespan timespan = (Timespan)this.timespan.getSingle(event);
        if (timespan == null) {
            return null;
        }
        long mills = timespan.getMilliSeconds();
        long out = 0L;
        if (this.mode == 0) {
            out = mills;
        } else if (this.mode == 1) {
            out = TimeUnit.MILLISECONDS.toSeconds(mills);
        } else if (this.mode == 2) {
            out = TimeUnit.MILLISECONDS.toMinutes(mills);
        } else if (this.mode == 3) {
            out = TimeUnit.MILLISECONDS.toHours(mills);
        } else if (this.mode == 4) {
            out = TimeUnit.MILLISECONDS.toDays(mills);
        } else if (this.mode == 5) {
            out = Math.round((double)mills / 6.944444444444445);
        } else if (this.mode == 6) {
            out = Math.round((double)mills / 25000.0);
        } else if (this.mode == 7) {
            out = Math.round((double)mills / 1200000.0);
        }
        return new Long[]{out};
    }
}

