/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import uk.co.umbaska.Umbaska;

public class Updater {
    public static String updatedVersion = null;

    public Runnable runUpdate() {
        return new Runnable(){

            @Override
            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)Umbaska.get(), new Runnable(){

                    @Override
                    public void run() {
                        Umbaska.logUpdater("Checking for updates..");
                        String newVersion = "";
                        try {
                            URL verUrl = new URL("http://umbaska.gatt.space/version.txt");
                            HttpURLConnection verhttpcon = (HttpURLConnection)verUrl.openConnection();
                            verhttpcon.setRequestProperty("User-Agent", "Mozilla/5.0");
                            InputStream verinsteam = verhttpcon.getInputStream();
                            BufferedReader verreader = new BufferedReader(new InputStreamReader(verinsteam, "UTF-8"));
                            newVersion = verreader.readLine();
                            verreader.close();
                        }
                        catch (IOException e) {
                            Umbaska.logWarning("An error occured: " + e.getCause().getMessage());
                        }
                        String currentVersion = Umbaska.get().getDescription().getVersion();
                        if (currentVersion.equals(newVersion) && !Umbaska.debug) {
                            Umbaska.logUpdater("It seems like your using the latest version of the plugin, I can't update it");
                            return;
                        }
                        Umbaska.logUpdater("Umbaska " + newVersion + " was released! You are using " + currentVersion + ".");
                        Umbaska.logUpdater("Downloading..");
                        File updated = new File(Umbaska.get().getDataFolder(), "Umbaska.jar");
                        try {
                            int bytesRead;
                            if (!updated.exists()) {
                                updated.createNewFile();
                            }
                            URL verUrl = new URL("http://umbaska.gatt.space/download.php?file=Umbaska.jar");
                            HttpURLConnection verhttpcon = (HttpURLConnection)verUrl.openConnection();
                            verhttpcon.setRequestProperty("User-Agent", "Mozilla/5.0");
                            InputStream inStream = verhttpcon.getInputStream();
                            FileOutputStream outStream = new FileOutputStream(updated);
                            byte[] buffer = new byte[inStream.available()];
                            while ((bytesRead = inStream.read(buffer)) != -1) {
                                ((OutputStream)outStream).write(buffer, 0, bytesRead);
                            }
                            inStream.close();
                            ((OutputStream)outStream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return;
                        }
                        Umbaska.logUpdater("Downloaded!");
                        new File(Umbaska.class.getProtectionDomain().getCodeSource().getLocation().getFile()).delete();
                        Umbaska.logUpdater("Removed old plugin version");
                        File moved = new File(Umbaska.get().getDataFolder(), "../Umbaska.jar");
                        Umbaska.logUpdater("Moving newest Umbaska.jar to plugins folder");
                        try {
                            Files.move(updated.toPath(), moved.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            Umbaska.logUpdater("An error has occured while attempting to move downloaded jar to the plugins folder.");
                            e.printStackTrace();
                        }
                        if (!moved.exists()) {
                            Umbaska.logUpdater("The file wasn't moved to the plugins folder for some reason. What.");
                            return;
                        }
                        Umbaska.logUpdater("The update was downloaded! Just restart your server :)");
                        updatedVersion = newVersion;
                    }
                });
            }
        };
    }

    public Runnable checkUpdates() {
        return new Runnable(){

            @Override
            public void run() {
                Umbaska.logDebug("[Updater] Checking for updates..");
                String newVersion = "";
                try {
                    URL verUrl = new URL("http://umbaska.gatt.space/version.txt");
                    HttpURLConnection verhttpcon = (HttpURLConnection)verUrl.openConnection();
                    verhttpcon.setRequestProperty("User-Agent", "Mozilla/5.0");
                    InputStream verinsteam = verhttpcon.getInputStream();
                    BufferedReader verreader = new BufferedReader(new InputStreamReader(verinsteam, "UTF-8"));
                    newVersion = verreader.readLine();
                    verreader.close();
                }
                catch (IOException e) {
                    Umbaska.logDebug("[Updater] An error occured: " + e.getCause().getMessage());
                }
                String currentVersion = Umbaska.get().getDescription().getVersion();
                if (!Objects.equals(currentVersion, newVersion)) {
                    if (updatedVersion == null) {
                        Umbaska.logUpdater("Umbaska " + newVersion + " was released! You are using " + currentVersion + ".");
                        Umbaska.logUpdater("To download the update, just use /umb update");
                    } else {
                        Umbaska.logUpdater("New version of Umbaska, " + newVersion + ", was found.");
                        Umbaska.logUpdater("I know you downloaded an update in this session already, but there is a newer one!");
                        Umbaska.logUpdater("Currently " + currentVersion + "is enabled, and " + updatedVersion + " is downloaded");
                        Umbaska.logUpdater("Use the command /umb update again!");
                    }
                }
            }
        };
    }

    public void scheduleUpdates() {
        if (Umbaska.get().getConfig().getBoolean("enable_update_checker")) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Umbaska.get(), this.checkUpdates(), 1L, 24000L);
        } else {
            Umbaska.logInfo("Checking for updates is disabled in config, so I'll check it only once,");
            Umbaska.logInfo("And I won't disturb you anymore, okay?");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Umbaska.get(), this.checkUpdates());
        }
    }
}

