/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;

public class LogFilesUtil {
    public boolean wasPrepared = false;
    private FileWriter fileWriter;
    private BufferedWriter bufferedWriter;
    private PrintWriter printWriter;
    private Path filePath;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");

    public LogFilesUtil(Path logFilePath) {
        this.filePath = logFilePath;
    }

    public void log(Level level, String toLog) {
        if (!this.shouldWorkFine()) {
            this.prepare();
            if (!this.shouldWorkFine()) {
                return;
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append(this.simpleDateFormat.format(Calendar.getInstance().getTime()));
        builder.append("] ");
        builder.append(toLog.substring(10));
        this.printWriter.println(builder.toString());
    }

    public boolean shouldWorkFine() {
        if (!this.wasPrepared) {
            return false;
        }
        return this.printWriter != null;
    }

    public void prepare() {
        try {
            File file = this.filePath.toFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this.fileWriter = new FileWriter(file);
            this.bufferedWriter = new BufferedWriter(this.fileWriter);
            this.printWriter = new PrintWriter(this.bufferedWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.wasPrepared = true;
    }

    public void close() {
        this.wasPrepared = false;
        this.printWriter.close();
        try {
            this.fileWriter.close();
            this.bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.bufferedWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

