/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils.Disguise.DisguiseUTIL;

import java.util.Collection;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityBat;
import net.minecraft.server.v1_8_R3.EntityBlaze;
import net.minecraft.server.v1_8_R3.EntityCaveSpider;
import net.minecraft.server.v1_8_R3.EntityChicken;
import net.minecraft.server.v1_8_R3.EntityCow;
import net.minecraft.server.v1_8_R3.EntityCreeper;
import net.minecraft.server.v1_8_R3.EntityEnderDragon;
import net.minecraft.server.v1_8_R3.EntityEnderman;
import net.minecraft.server.v1_8_R3.EntityEndermite;
import net.minecraft.server.v1_8_R3.EntityGhast;
import net.minecraft.server.v1_8_R3.EntityGiantZombie;
import net.minecraft.server.v1_8_R3.EntityGuardian;
import net.minecraft.server.v1_8_R3.EntityHorse;
import net.minecraft.server.v1_8_R3.EntityIronGolem;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityMagmaCube;
import net.minecraft.server.v1_8_R3.EntityMushroomCow;
import net.minecraft.server.v1_8_R3.EntityOcelot;
import net.minecraft.server.v1_8_R3.EntityPig;
import net.minecraft.server.v1_8_R3.EntityPigZombie;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityRabbit;
import net.minecraft.server.v1_8_R3.EntitySheep;
import net.minecraft.server.v1_8_R3.EntitySilverfish;
import net.minecraft.server.v1_8_R3.EntitySkeleton;
import net.minecraft.server.v1_8_R3.EntitySlime;
import net.minecraft.server.v1_8_R3.EntitySnowman;
import net.minecraft.server.v1_8_R3.EntitySpider;
import net.minecraft.server.v1_8_R3.EntitySquid;
import net.minecraft.server.v1_8_R3.EntityVillager;
import net.minecraft.server.v1_8_R3.EntityWitch;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.EntityWolf;
import net.minecraft.server.v1_8_R3.EntityZombie;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.PlayerConnection;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.Utils.Disguise.DisguiseAPI_V1_8_R3;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.Disguise;

public class EntityDisguise_V1_8_R3
extends Disguise {
    private EntityLiving living;

    public EntityDisguise_V1_8_R3(org.bukkit.entity.Entity p, EntityType type) {
        super(p, type);
        new DisguisedEntityTracker((CraftEntity)this.getPlayer());
    }

    public String getName() {
        String name = "Pig";
        switch (this.living.getBukkitEntity().getType()) {
            case CAVE_SPIDER: {
                name = "Cave Spider";
                break;
            }
            case HORSE: {
                name = "Horse";
                break;
            }
            case IRON_GOLEM: {
                name = "Iron Golem";
                break;
            }
            case MAGMA_CUBE: {
                name = "Magma Cube";
                break;
            }
            case MINECART: {
                name = "Minecart";
                break;
            }
            case MINECART_CHEST: {
                name = "Minecart w/ Chest";
                break;
            }
            case MINECART_COMMAND: {
                name = "Minecart w/ Command Block";
                break;
            }
            case MINECART_FURNACE: {
                name = "Minecart w/ Furnace";
                break;
            }
            case MINECART_HOPPER: {
                name = "Minecart w/ Hopper";
                break;
            }
            case MINECART_MOB_SPAWNER: {
                name = "Minecart w/ Spawner";
                break;
            }
            case MINECART_TNT: {
                name = "Minecart w/ TNT";
                break;
            }
            case MUSHROOM_COW: {
                name = "Mooshroom";
                break;
            }
            case OCELOT: {
                name = "Ocelot";
                break;
            }
            case PAINTING: {
                name = "Painting";
                break;
            }
            case PIG_ZOMBIE: {
                name = "Zombie Pigman";
                break;
            }
            case SKELETON: {
                Skeleton skeleton = (Skeleton)this.living.getBukkitEntity();
                name = skeleton.getSkeletonType() == Skeleton.SkeletonType.NORMAL ? "Skeleton" : "Wither Skeleton";
                break;
            }
            case SNOWMAN: {
                name = "Snow Golem";
                break;
            }
            case WITHER: {
                name = "Wither Boss";
                break;
            }
            default: {
                name = this.living.getBukkitEntity().getType().getName();
            }
        }
        return name;
    }

    @Override
    public void applyDisguise(Collection<Player> players) {
        Entity ep = ((CraftEntity)this.getPlayer()).getHandle();
        EntityLiving ent = this.convert(this.getType());
        ent.setLocation(ep.locX, ep.locY, ep.locZ, ep.yaw, ep.pitch);
        PacketPlayOutEntityDestroy destroy = new PacketPlayOutEntityDestroy(new int[]{ep.getId()});
        PacketPlayOutSpawnEntityLiving spawn = new PacketPlayOutSpawnEntityLiving(ent);
        for (Player p : players) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            PlayerConnection pc = aep.playerConnection;
            pc.sendPacket((Packet)destroy);
            pc.sendPacket((Packet)spawn);
        }
        this.living = ent;
    }

    @Override
    public void revertDisguise(Collection<Player> players) {
        PacketPlayOutEntityDestroy destroy = new PacketPlayOutEntityDestroy(new int[]{this.living.getId()});
        EntityLiving ep = (EntityLiving)this.getPlayer();
        PacketPlayOutPlayerInfo infoAdd = null;
        if (this.getPlayer().getType() == EntityType.PLAYER) {
            infoAdd = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{((CraftPlayer)this.getPlayer()).getHandle()});
        }
        PacketPlayOutSpawnEntityLiving spawn = new PacketPlayOutSpawnEntityLiving(ep);
        for (Player p : players) {
            if (this.getPlayer().getType() == EntityType.PLAYER && p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            PlayerConnection pc = aep.playerConnection;
            pc.sendPacket((Packet)destroy);
            if (infoAdd != null) {
                pc.sendPacket((Packet)infoAdd);
            }
            pc.sendPacket((Packet)spawn);
        }
    }

    @Override
    public void move(Location old, Location newloc) {
        PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook moveLook = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.living.getId(), (byte)((newloc.getBlockX() - old.getBlockX()) * 32), (byte)((newloc.getBlockY() - old.getBlockY()) * 32), (byte)((newloc.getBlockZ() - old.getBlockZ()) * 32), (byte)newloc.getYaw(), (byte)newloc.getPitch(), this.getPlayer().isOnGround());
        PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation((Entity)this.living, (byte)(newloc.getYaw() * 256.0f / 360.0f));
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            aep.playerConnection.sendPacket((Packet)moveLook);
            aep.playerConnection.sendPacket((Packet)rotation);
        }
    }

    private EntityLiving convert(EntityType type) {
        EntityBlaze living = null;
        Entity ep = ((CraftEntity)this.getPlayer()).getHandle();
        World world = ep.getWorld();
        switch (type) {
            case BAT: {
                EntityBat bat = new EntityBat(world);
                living = bat;
                break;
            }
            case BLAZE: {
                living = new EntityBlaze(world);
                break;
            }
            case CAVE_SPIDER: {
                living = new EntityCaveSpider(world);
                break;
            }
            case CHICKEN: {
                living = new EntityChicken(world);
                break;
            }
            case COW: {
                living = new EntityCow(world);
                break;
            }
            case CREEPER: {
                living = new EntityCreeper(world);
                break;
            }
            case ENDERMAN: {
                living = new EntityEnderman(world);
                break;
            }
            case ENDERMITE: {
                living = new EntityEndermite(world);
                break;
            }
            case ENDER_DRAGON: {
                living = new EntityEnderDragon(world);
                break;
            }
            case GHAST: {
                living = new EntityGhast(world);
                break;
            }
            case GIANT: {
                living = new EntityGiantZombie(world);
                break;
            }
            case GUARDIAN: {
                living = new EntityGuardian(world);
                break;
            }
            case HORSE: {
                living = new EntityHorse(world);
                break;
            }
            case IRON_GOLEM: {
                living = new EntityIronGolem(world);
                break;
            }
            case MAGMA_CUBE: {
                living = new EntityMagmaCube(world);
                break;
            }
            case MUSHROOM_COW: {
                living = new EntityMushroomCow(world);
                break;
            }
            case OCELOT: {
                living = new EntityOcelot(world);
                break;
            }
            case PIG: {
                living = new EntityPig(world);
                break;
            }
            case PIG_ZOMBIE: {
                living = new EntityPigZombie(world);
                break;
            }
            case RABBIT: {
                living = new EntityRabbit(world);
                break;
            }
            case SHEEP: {
                living = new EntitySheep(world);
                break;
            }
            case SILVERFISH: {
                living = new EntitySilverfish(world);
                break;
            }
            case SKELETON: {
                living = new EntitySkeleton(world);
                break;
            }
            case SLIME: {
                living = new EntitySlime(world);
                break;
            }
            case SNOWMAN: {
                living = new EntitySnowman(world);
                break;
            }
            case SPIDER: {
                living = new EntitySpider(world);
                break;
            }
            case SQUID: {
                living = new EntitySquid(world);
                break;
            }
            case VILLAGER: {
                living = new EntityVillager(world);
                break;
            }
            case WITCH: {
                living = new EntityWitch(world);
                break;
            }
            case WITHER: {
                living = new EntityWither(world);
                break;
            }
            case WOLF: {
                living = new EntityWolf(world);
                break;
            }
            case ZOMBIE: {
                living = new EntityZombie(world);
                break;
            }
            default: {
                living = new EntityPig(world);
            }
        }
        return living;
    }

    public EntityLiving getEntity() {
        return this.living;
    }

    public class DisguisedEntityTracker {
        CraftEntity e;
        BukkitTask task;

        public DisguisedEntityTracker(CraftEntity ent) {
            this.e = ent;
            final DisguiseAPI_V1_8_R3 disAPI = (DisguiseAPI_V1_8_R3)Umbaska.disguiseAPI;
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)Umbaska.get(), new Runnable(){
                Location prevLocation;
                {
                    this.prevLocation = DisguisedEntityTracker.this.e.getLocation();
                }

                @Override
                public void run() {
                    if (DisguisedEntityTracker.this.e.isDead() || (double)((EntityLiving)DisguisedEntityTracker.this.e.getHandle()).getHealth() <= 0.0) {
                        disAPI.unDisguisePlayer((org.bukkit.entity.Entity)DisguisedEntityTracker.this.e);
                        disAPI.getDisguise((org.bukkit.entity.Entity)DisguisedEntityTracker.this.e).revertDisguise(disAPI.online());
                        disAPI.refresh();
                        DisguisedEntityTracker.this.task.cancel();
                    }
                    if (disAPI.getDisguise((org.bukkit.entity.Entity)DisguisedEntityTracker.this.e) != null) {
                        Disguise dis = disAPI.getDisguise((org.bukkit.entity.Entity)DisguisedEntityTracker.this.e);
                        dis.move(this.prevLocation, DisguisedEntityTracker.this.e.getLocation());
                        this.prevLocation = DisguisedEntityTracker.this.e.getLocation();
                    } else {
                        DisguisedEntityTracker.this.task.cancel();
                    }
                }
            }, 1L, 1L);
        }
    }
}

