/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska;

import ca.thederpygolems.armorequip.ArmourListener;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.util.StringUtils;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.google.common.io.ByteArrayDataInput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.dynmap.DynmapAPI;
import uk.co.umbaska.Bungee.Messenger;
import uk.co.umbaska.Debugger;
import uk.co.umbaska.LargeSk.util.MetricsManager;
import uk.co.umbaska.Managers.OldRegister;
import uk.co.umbaska.Misc.ExprNetworking;
import uk.co.umbaska.ProtocolLib.EntityHider;
import uk.co.umbaska.Registration.Register;
import uk.co.umbaska.Registration.Version;
import uk.co.umbaska.System.WildSkriptTimer;
import uk.co.umbaska.UmbaskaCommand;
import uk.co.umbaska.Utils.Disguise.DisguiseAPI;
import uk.co.umbaska.Utils.FreezeListener;
import uk.co.umbaska.Utils.ItemManager;
import uk.co.umbaska.Utils.LogFilesUtil;
import uk.co.umbaska.Utils.TPSUtil;
import uk.co.umbaska.Utils.UmbaskaLogLevel;
import uk.co.umbaska.Utils.Updater;

public class Umbaska
extends JavaPlugin
implements Listener {
    public static Entity armorStand;
    public static DynmapAPI api;
    public static EntityHider protocolLibEntityHider;
    public static FreezeListener freezeListener;
    public static ItemManager itemManager;
    public static String schematicsFolder;
    public static HashMap<UUID, String> tokenTracker;
    public static HashMap<String, String> globalKeyCache;
    public static String bungeeServerName;
    public static Boolean usingUmbaskaCord;
    public static ByteArrayDataInput bytein;
    public static Messenger messenger;
    public static Boolean disableSkRambled;
    public static HashMap<UUID, InetAddress> addressMap;
    public static Integer bcheartbeat;
    public static Boolean umbCordDebug;
    public static Object disguiseAPI;
    public static boolean debug;
    public static boolean isUsingBungee;
    public static boolean wasEnabled;
    public static Permission perms;
    private static WildSkriptTimer timer;
    private static Logger logger;
    private static LogFilesUtil logFilesUtil;
    public static boolean usingDiscord;
    private static Boolean inError;
    final int CONFIG_VERSION = 1;
    public Debugger debugger = new Debugger(this, true);
    public List<String> oq = Collections.synchronizedList(new ArrayList());
    public Integer qc = 0;
    public String spacer = "@@UMB@@";
    private ProtocolManager protocolManager;
    private Boolean generateDocumentation = false;
    protected static Umbaska i;

    public Umbaska() {
        i = this;
        debug = this.getConfig().getBoolean("debug_info");
    }

    public static Umbaska get() {
        return i;
    }

    public void onEnable() {
        File config;
        logFilesUtil = new LogFilesUtil(Paths.get(this.getDataFolder().toString(), File.separator, "newlog.txt"));
        Skript skript = Skript.getInstance();
        PluginManager manager = Bukkit.getPluginManager();
        if (skript == null) {
            Umbaska.logError("Whooops! Looks like you don't have Skript on your server.");
            Umbaska.logError("You can download it from http://forums.skunity.com/");
            manager.disablePlugin((Plugin)this);
            return;
        }
        if (this.getConfig() == null) {
            Umbaska.logError("Umbaska's getConfig() method is null. Strange that it happened, report please");
        }
        this.getConfig().set("umbaska_version", (Object)this.getDescription().getVersion());
        if (this.getConfig().getInt("config_version") != 1 && (config = new File(this.getDataFolder() + File.separator + "config.yml")).exists()) {
            if (config.delete()) {
                Umbaska.logWarning("Your ./plugins/Umbaska/config.yml file was reset to work with current Umbaska version");
            } else {
                Umbaska.logError("An error occurred while attempting to delete the ./plugins/Umbaska.config.yml file");
            }
        }
        this.saveDefaultConfig();
        Version.checkServerVersion();
        this.registerConsoleListener();
        Skript.registerAddon((JavaPlugin)this);
        PluginCommand cmd = this.getCommand("umbaska");
        if (cmd == null) {
            Umbaska.logWarning("Couldn't register Umbaska's main command! Probably the plugin.yml file is wrong.");
        } else {
            cmd.setExecutor((CommandExecutor)new UmbaskaCommand());
        }
        new TPSUtil((Plugin)this);
        manager.registerEvents((Listener)new ExprNetworking(), (Plugin)this);
        manager.registerEvents((Listener)new ArmourListener(this.getConfig().getStringList("blocked")), (Plugin)this);
        if (OldRegister.getVersion().contains("1_7") && !this.getConfig().getBoolean("enable_1.7_override")) {
            Umbaska.logWarning("Umbaska 2.0 doesn't work with Minecraft 1.7! Sorry!If you wish to load Umbaska anyway, set 'enable_1.7_override' to true in the config.");
            manager.disablePlugin((Plugin)this);
            return;
        }
        if (this.getConfig().getBoolean("enable_1.7_override")) {
            Umbaska.logWarning("The plugin has been enabled with 1.7 Override Mode Enabled.");
            Umbaska.logWarning("We take no responsibility for any damage done.");
            Umbaska.logWarning("We will ignore any reports regarding servers that enable the 1.7/1.8 override.");
        }
        try {
            Register.registerAll();
        }
        catch (Exception ex) {
            Umbaska.logError("Registering syntaxes failed at some point:");
            ex.printStackTrace();
            Umbaska.logError("Most of things won't work.");
            Umbaska.logError("Let me enable the rest of Umbaska..");
        }
        wasEnabled = true;
        logFilesUtil.flush();
        disguiseAPI = DisguiseAPI.getAPI();
        ((DisguiseAPI)disguiseAPI).initialize(this);
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        Plugin pl = Bukkit.getServer().getPluginManager().getPlugin("ProtocolLib");
        if (pl != null) {
            protocolLibEntityHider = new EntityHider((Plugin)Umbaska.get(), EntityHider.Policy.BLACKLIST);
        }
        FileConfiguration config2 = this.getConfig();
        pl = Bukkit.getServer().getPluginManager().getPlugin("SkRambled");
        disableSkRambled = pl != null;
        isUsingBungee = config2.getBoolean("use_bungee");
        Boolean bungee_autocache = config2.getBoolean("enable_bungee_autocache");
        Integer autocache_heartbeat = config2.getInt("bungee_autocache_heartbeat");
        if (autocache_heartbeat <= 0) {
            Umbaska.logWarning("AutoCache Heartbeat is set to a value below than or equal to 0! Resetting to default 20!");
            this.getConfig().set("bungee_autocache_heartbeat", (Object)20);
            autocache_heartbeat = this.getConfig().getInt("bungee_autocache_heartbeat");
        }
        if (isUsingBungee && bungee_autocache.booleanValue()) {
            messenger = new Messenger((Plugin)this, true, autocache_heartbeat);
            this.getLogger().info("BungeeCord Auto Cache Enabled with a Heartbeat of " + autocache_heartbeat.toString() + " ticks.");
        } else {
            messenger = new Messenger((Plugin)this);
        }
        timer = new WildSkriptTimer();
        timer.run();
        schematicsFolder = this.getConfig().getString("schematic_location").replace("PLUGINFOLDER", this.getDataFolder().getAbsolutePath());
        this.saveDefaultConfig();
        OldRegister.registerAll();
        freezeListener = new FreezeListener((Plugin)this);
        itemManager = new ItemManager();
        if (usingUmbaskaCord.booleanValue()) {
            this.loadUmbaskaCordHook();
        }
        if (this.generateDocumentation.booleanValue()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    Umbaska.logDocs("Starting to register information");
                    Umbaska.this.generateDocs();
                }
            }, 20L);
        }
        MetricsManager.scheduleEnableMetrics();
        new Updater().scheduleUpdates();
    }

    public void onDisable() {
        MetricsManager.disableMetrics();
        i = null;
        File data = new File(this.getDataFolder(), "data.txt");
        data.delete();
        this.debugger.close();
        logFilesUtil.close();
    }

    private synchronized void closeStream(final InputStream stream) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 20L);
    }

    private synchronized void generateDocs() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (String key : OldRegister.effectList.keySet()) {
                    String url = Umbaska.this.getConfig().getString("start_up_args");
                    String syntax = "";
                    for (String s : OldRegister.effectList.get(key)) {
                        syntax = syntax + s + "||";
                    }
                    key = key.replaceAll(" ", "_");
                    syntax = syntax.replaceAll(" ", "_");
                    URL targetURL = null;
                    try {
                        targetURL = new URL(url.toString() + "?type=effects&name=" + key + "&syntax=" + syntax + "");
                        Bukkit.getLogger().info(targetURL.toString());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    if (targetURL == null) continue;
                    try {
                        Umbaska.this.closeStream(targetURL.openStream());
                    }
                    catch (IOException e) {}
                }
            }
        });
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (String key : OldRegister.expressionList.keySet()) {
                    String url = Umbaska.this.getConfig().getString("start_up_args");
                    String syntax = "";
                    for (String s : OldRegister.expressionList.get(key)) {
                        syntax = syntax + s + "||";
                    }
                    key = key.replaceAll(" ", "_");
                    syntax = syntax.replaceAll(" ", "_");
                    URL targetURL = null;
                    try {
                        targetURL = new URL(url.toString() + "?type=expressions&name=" + key + "&syntax=" + syntax + "");
                        Bukkit.getLogger().info(targetURL.toString());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    if (targetURL == null) continue;
                    try {
                        Umbaska.this.closeStream(targetURL.openStream());
                    }
                    catch (IOException e) {}
                }
            }
        });
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (String key : OldRegister.simpleexpressionList.keySet()) {
                    String url = Umbaska.this.getConfig().getString("start_up_args");
                    String syntax = "";
                    for (String s : OldRegister.simpleexpressionList.get(key)) {
                        syntax = syntax + s + "||";
                    }
                    key = key.replaceAll(" ", "_");
                    syntax = syntax.replaceAll(" ", "_");
                    URL targetURL = null;
                    try {
                        targetURL = new URL(url.toString() + "?type=expressions&name=" + key + "&syntax=" + syntax + "");
                        Bukkit.getLogger().info(targetURL.toString());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    if (targetURL == null) continue;
                    try {
                        Umbaska.this.closeStream(targetURL.openStream());
                    }
                    catch (IOException e) {}
                }
            }
        });
    }

    public void registerConsoleListener() {
        this.getLogger().info("Registering console listener...");
        Bukkit.getServer().getLogger().addHandler(new Handler(){

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }

            @Override
            public void publish(LogRecord logRecord) {
                String msg = logRecord.getMessage();
                if (inError.booleanValue()) {
                    String ajoined;
                    inError = false;
                    Object[] plugins = new String[Bukkit.getPluginManager().getPlugins().length];
                    Integer i = -1;
                    for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                        plugins[i.intValue()] = p.getName() + " - " + p.getDescription().getVersion() + ", ";
                    }
                    plugins[i.intValue()] = plugins[i].replaceAll(", ", "");
                    String pjoined = StringUtils.join((Object[])plugins);
                    try {
                        if (Skript.getAddons() == null) {
                            ajoined = "Failed to get addons hooked into Skript!";
                        } else {
                            ArrayList<String> addons = new ArrayList<String>();
                            for (SkriptAddon p : Skript.getAddons()) {
                                addons.add(Bukkit.getPluginManager().getPlugin(p.getName()).getDescription().getFullName() != null ? Bukkit.getPluginManager().getPlugin(p.getName()).getDescription().getFullName() : ("Unknown plugin - " + Bukkit.getPluginManager().getPlugin(p.getName()).getDescription().getVersion() != null ? Bukkit.getPluginManager().getPlugin(p.getName()).getDescription().getVersion() : "Unknown version, "));
                            }
                            ajoined = StringUtils.join(addons);
                        }
                    }
                    catch (NullPointerException npe) {
                        ajoined = "Failed to get addons hooked into Skript (NPE)!";
                    }
                    Logger skl = Bukkit.getLogger();
                    skl.severe("#!#! ");
                    skl.severe("#!#! List of plugins: ");
                    skl.severe("#!#! " + pjoined);
                    skl.severe("#!#! ");
                    skl.severe("#!#! List of addons: ");
                    skl.severe("#!#! " + ajoined);
                    skl.severe("#!#! ");
                } else if (msg.contains("#!#! End of Error")) {
                    inError = true;
                }
            }
        });
        Umbaska.log("Registered console listener");
    }

    private void loadUmbaskaCordHook() {
        Bukkit.getLogger().info("UMBASKACORD SUPPORT HAS BEEN COMPLETELY REMOVED. RIP UMBASKACORD.");
    }

    public boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        perms = (Permission)rsp.getProvider();
        return perms != null;
    }

    private void saveData() {
        try {
            FileOutputStream os = new FileOutputStream(new File(this.getDataFolder(), "data.txt"));
            PrintStream ps = new PrintStream(os);
            for (String s : this.oq) {
                ps.println("oq:" + s);
            }
            ps.println("qc:" + String.valueOf(this.qc));
            ps.close();
            this.debugger.debug("All data saved.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        block10: {
            try {
                File file = new File(this.getDataFolder(), "data.txt");
                if (file.exists()) {
                    try (BufferedReader br = new BufferedReader(new FileReader(file));){
                        String l = br.readLine();
                        while (l != null) {
                            if (l.startsWith("oq:")) {
                                this.oq.add(new String(l.substring(3)));
                            } else if (l.startsWith("qc:")) {
                                this.qc = Integer.parseInt(new String(l.substring(3)));
                            }
                            l = br.readLine();
                        }
                        this.debugger.debug("All data loaded.");
                        break block10;
                    }
                }
                this.debugger.debug("A data file was not found. If this is your first start-up with the plugin, this is normal.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpawn(CreatureSpawnEvent e) {
        e.getEntity().setMetadata("spawnreason", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)e.getSpawnReason().toString()));
    }

    public ProtocolManager getProtocolManager() {
        if (this.protocolManager == null) {
            this.protocolManager = ProtocolLibrary.getProtocolManager();
        }
        return this.protocolManager;
    }

    public static WildSkriptTimer getTimer() {
        return timer;
    }

    public static void log(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.INFO, toLog);
    }

    public static void logDebug(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.DEBUG, toLog);
    }

    public static void logDebug(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.DEBUG, clazz, toLog);
    }

    public static void logDocs(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.DOCS, toLog);
    }

    public static void logDocs(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.DOCS, clazz, toLog);
    }

    public static void logEmpty() {
        Umbaska.logEmpty(UmbaskaLogLevel.INFO, 1);
    }

    public static void logEmpty(UmbaskaLogLevel level) {
        Umbaska.logEmpty(level, 1);
    }

    public static void logEmpty(int amount) {
        Umbaska.logEmpty(UmbaskaLogLevel.INFO, amount);
    }

    public static void logError(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.ERROR, toLog);
    }

    public static void logError(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.ERROR, clazz, toLog);
    }

    public static void logFail(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.FAIL, toLog);
    }

    public static void logFail(@Nullable Class<?> clazz, Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.FAIL, clazz, toLog);
    }

    public static void logInfo(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.INFO, toLog);
    }

    public static void logWarning(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.WARNING, toLog);
    }

    public static void logUpdater(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.UPDATER, toLog);
    }

    public static void logEmpty(UmbaskaLogLevel level, int amount) {
        for (int n = 0; n < amount; ++n) {
            Umbaska.log(level, null);
        }
    }

    public static void logToFile(Object ... toLog) {
        Umbaska.log(UmbaskaLogLevel.FILE_ONLY, null, toLog);
    }

    public static void log(UmbaskaLogLevel level, Class<?> clazz, Object ... toLog) {
        if (clazz == null) {
            Umbaska.log(level, toLog);
            return;
        }
        Umbaska.log(level, "[", clazz.getCanonicalName(), "] ", org.apache.commons.lang3.StringUtils.join((Object[])toLog));
    }

    public static void log(@Nullable UmbaskaLogLevel level, Object ... toLog) {
        if (toLog == null) {
            toLog = new String[]{""};
        }
        if (level == null) {
            level = UmbaskaLogLevel.INFO;
        }
        StringBuilder builder = new StringBuilder("[Umbaska] ");
        Level bukkitLevel = Level.INFO;
        switch (level) {
            case INFO: {
                break;
            }
            case DOCS: {
                builder.append("[Docs] ");
                break;
            }
            case FAIL: {
                builder.append("[Fail] ");
                bukkitLevel = Level.WARNING;
                break;
            }
            case WARNING: {
                bukkitLevel = Level.WARNING;
                break;
            }
            case ERROR: {
                bukkitLevel = Level.SEVERE;
                break;
            }
            case UPDATER: {
                builder.append("[Updater] ");
                break;
            }
            case DEBUG: {
                break;
            }
        }
        for (Object o : toLog) {
            if (o == null) continue;
            if (o instanceof String) {
                builder.append(o);
                continue;
            }
            if (o instanceof String[]) {
                String[] k;
                for (String l : k = (String[])o) {
                    builder.append(l);
                }
                continue;
            }
            builder.append(o.toString());
        }
        String end = builder.toString();
        if ((level != UmbaskaLogLevel.DEBUG || debug) && level != UmbaskaLogLevel.FILE_ONLY) {
            logger.log(bukkitLevel, end);
        }
        logFilesUtil.log(bukkitLevel, end);
        if (wasEnabled) {
            logFilesUtil.flush();
        }
    }

    static {
        tokenTracker = new HashMap();
        globalKeyCache = new HashMap();
        usingUmbaskaCord = true;
        addressMap = new HashMap();
        umbCordDebug = false;
        debug = true;
        isUsingBungee = false;
        wasEnabled = false;
        perms = null;
        logger = Bukkit.getLogger();
        usingDiscord = true;
        inError = false;
    }
}

