/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Registration;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import uk.co.umbaska.LargeSk.register.LargeSkRegister;
import uk.co.umbaska.ProtocolLib.EntityHider;
import uk.co.umbaska.Registration.AtLeast;
import uk.co.umbaska.Registration.Dependency;
import uk.co.umbaska.Registration.DontRegister;
import uk.co.umbaska.Registration.InfoClass;
import uk.co.umbaska.Registration.Name;
import uk.co.umbaska.Registration.SyntaxElement;
import uk.co.umbaska.Registration.Syntaxes;
import uk.co.umbaska.Registration.Version;
import uk.co.umbaska.Umbaska;
import uk.co.umbaska.Utils.DocsPassword;
import uk.co.umbaska.Utils.UmbaskaLogLevel;

public class Register {
    private static boolean generateDocs;
    private static ArrayList<String> docList;
    private static PluginManager pluginManager;
    private static Plugin plugin;
    private static HashMap<SyntaxElement, Integer> registeredAmount;
    private static HashMap<SyntaxElement, Integer> failedAmount;

    public static void registerAll() {
        Register.registerAll("uk.co.umbaska");
    }

    public static void registerAll(String pckg) {
        long startTime = System.nanoTime();
        generateDocs = Umbaska.debug;
        PluginManager pm = Bukkit.getPluginManager();
        Plugin plotMe = pm.getPlugin("PlotMe");
        Plugin plotSquared = pm.getPlugin("PlotSquared");
        String plotMessagePrefix = "";
        if (plotMe != null) {
            Umbaska.logWarning("Umbaska supports only an old version of PlotMe - 0.13b!");
            Umbaska.logWarning("Consider migrating to PlotSquared - it's better in general and has a good Umbaska support");
            plotMessagePrefix = "Also, ";
        }
        if (plotMe != null & plotSquared != null) {
            Umbaska.logFail(plotMessagePrefix, "Umbaska DOESN'T support having both PlotSquared and PlotMe installed on one server.");
            Umbaska.logFail("There is also no need for you to use both. Consider removing one.");
        }
        new LargeSkRegister().registerAll();
        if (pluginManager.getPlugin("ProtocolLib") != null) {
            Umbaska.protocolLibEntityHider = new EntityHider((Plugin)Umbaska.get(), EntityHider.Policy.BLACKLIST);
        }
        Reflections refls = new Reflections(pckg, new Scanner[0]);
        for (SyntaxElement element : SyntaxElement.values()) {
            registeredAmount.put(element, 0);
        }
        for (SyntaxElement element : SyntaxElement.values()) {
            failedAmount.put(element, 0);
        }
        Set infoClasses = refls.getTypesAnnotatedWith(InfoClass.class);
        for (Class exClass : SyntaxElement.getUmbaskaExtensionClasses()) {
            Umbaska.logEmpty(UmbaskaLogLevel.DEBUG);
            Umbaska.logDebug("Finding Version-Dependent ", exClass.getName());
            Set classes = refls.getSubTypesOf(exClass);
            for (Class clazz : classes) {
                String name = clazz.getName();
                String dashV = name.substring(name.length() - 8, name.length() - 6);
                if (!dashV.equalsIgnoreCase("_V")) continue;
                Version ver = Version.parse(name.substring(name.length() - 7));
                Umbaska.logDebug(clazz, new Object[]{"Found compatibility with Minecraft ", ver, ", UmbVerID: ", ver.getId(), Version.serverVersion == ver ? ". Registering..." : null});
                if (Version.serverVersion != ver) continue;
                String elementName = name.substring(0, name.length() - 8);
                Class info = null;
                for (Class cla : infoClasses) {
                    if (!cla.getName().substring(0, cla.getName().length() - 5).equalsIgnoreCase(elementName)) continue;
                    info = cla;
                }
                if (info == null) {
                    Umbaska.logFail(clazz, "I couldn't find any matching class ending with \"_Info\".");
                    continue;
                }
                SyntaxElement element = SyntaxElement.parseClass(exClass);
                if (element == SyntaxElement.CONDITION) {
                    Register.condition(clazz, info);
                    continue;
                }
                if (element == SyntaxElement.EFFECT) {
                    Register.effect(clazz, info);
                    continue;
                }
                if (element == SyntaxElement.SIMPLE_EXPRESSION) {
                    Register.simpleExpression(clazz, info);
                    continue;
                }
                if (element == SyntaxElement.SIMPLE_PROPERTY_EXPRESSION) {
                    Register.simplePropertyExpression(clazz, info);
                    continue;
                }
                if (element == SyntaxElement.PROPERTY_EXPRESSION) {
                    Register.propertyExpression(clazz, info);
                    continue;
                }
                Umbaska.logError(clazz, "Unknown SyntaxElement.. something is wrong with the enum.");
            }
        }
        Umbaska.logDebug("Registrating Conditions..");
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG);
        Set conditions = refls.getSubTypesOf(Condition.class);
        for (Class clazz : conditions) {
            Umbaska.logDebug(clazz, "Starting Registration for a Condition.");
            Register.condition(clazz, clazz);
        }
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG, 2);
        Umbaska.logDebug("Registrating Effects..");
        Set effects = refls.getSubTypesOf(Effect.class);
        for (Class clazz : effects) {
            Umbaska.logDebug(clazz, "Starting Registration for an Effect");
            Register.effect(clazz, clazz);
        }
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG, 2);
        Umbaska.logDebug("Registrating SimpleExpressions..");
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG);
        Set simpleExpressions = refls.getSubTypesOf(SimpleExpression.class);
        for (Class clazz : simpleExpressions) {
            Umbaska.logDebug(clazz, "Starting Registration for a SimpleExpression.");
            Register.simpleExpression(clazz, clazz);
        }
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG, 2);
        Umbaska.logDebug("Registrating SimplePropertyExpressions..");
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG);
        Set simplePropertyExpressions = refls.getSubTypesOf(SimplePropertyExpression.class);
        for (Class clazz : simplePropertyExpressions) {
            Umbaska.logDebug(clazz, "Starting Registration for a SimplePropertyExpression.");
            Register.simplePropertyExpression(clazz, clazz);
        }
        Umbaska.logDebug("Registrating PropertyExpressions..");
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG);
        Set propertyExpressions = refls.getSubTypesOf(PropertyExpression.class);
        for (Class clazz : propertyExpressions) {
            Umbaska.logDebug(clazz, "Starting Registration for a PropertyExpression.");
            Register.propertyExpression(clazz, clazz);
        }
        Umbaska.logEmpty(UmbaskaLogLevel.DEBUG, 2);
        DecimalFormat df = new DecimalFormat();
        df.setMinimumFractionDigits(1);
        df.setMaximumFractionDigits(1);
        int totalRegisteredAmount = 0;
        int totalFailedAmount = 0;
        for (int loopAmount : registeredAmount.values()) {
            totalRegisteredAmount += loopAmount;
        }
        for (int loopAmount : failedAmount.values()) {
            totalFailedAmount += loopAmount;
        }
        int totalAmount = totalFailedAmount + totalRegisteredAmount;
        double percentage = totalFailedAmount == 0 ? 100.0 : (double)totalRegisteredAmount / (double)totalAmount * 100.0;
        String formattedPercentage = df.format(percentage);
        long took = System.nanoTime() - startTime;
        double tookMs = (double)took / 1000000.0;
        String tookString = df.format(tookMs);
        Umbaska.log("Registered ", totalRegisteredAmount, " out of ", totalRegisteredAmount + totalFailedAmount, " elements with ", totalFailedAmount, " errors (", formattedPercentage, "%) - Took ", tookString, "ms.");
    }

    public static void condition(Class<? extends Condition> clazz, Class<? extends Condition> info) {
        Syntaxes syntaxes = Register.validateAndGenerateDocs(SyntaxElement.CONDITION, clazz, info);
        if (syntaxes == null) {
            return;
        }
        Skript.registerCondition(clazz, (String[])syntaxes.value());
    }

    public static void effect(Class<? extends Effect> clazz, Class<? extends Effect> info) {
        Syntaxes syntaxes = Register.validateAndGenerateDocs(SyntaxElement.EFFECT, clazz, info);
        if (syntaxes == null) {
            return;
        }
        Skript.registerEffect(clazz, (String[])syntaxes.value());
    }

    public static void simpleExpression(Class<? extends SimpleExpression> clazz, Class<? extends SimpleExpression> info) {
        Syntaxes syntaxes = Register.validateAndGenerateDocs(SyntaxElement.SIMPLE_EXPRESSION, clazz, info);
        if (syntaxes == null) {
            return;
        }
        Class returnClazz = Register.getExpressionReturnType(clazz);
        if (returnClazz == null) {
            Umbaska.logFail(Umbaska.debug ? null : clazz, "Couldn't register this SimpleExpression because the returnClazz is null");
        }
        Skript.registerExpression(clazz, (Class)returnClazz, (ExpressionType)ExpressionType.SIMPLE, (String[])syntaxes.value());
    }

    public static void simplePropertyExpression(Class<? extends SimplePropertyExpression> clazz, Class<? extends SimplePropertyExpression> info) {
        Syntaxes syntaxes = Register.validateAndGenerateDocs(SyntaxElement.SIMPLE_PROPERTY_EXPRESSION, clazz, info);
        if (syntaxes == null) {
            return;
        }
        Class returnClazz = Register.getExpressionReturnType(clazz);
        if (returnClazz == null) {
            Umbaska.logFail(Umbaska.debug ? null : clazz, "Couldn't register this SimplePropertyExpression because the returnClazz is null");
        }
        Skript.registerExpression(clazz, (Class)returnClazz, (ExpressionType)ExpressionType.PROPERTY, (String[])syntaxes.value());
    }

    public static void propertyExpression(Class<? extends PropertyExpression> clazz, Class<? extends PropertyExpression> info) {
        Syntaxes syntaxes = Register.validateAndGenerateDocs(SyntaxElement.PROPERTY_EXPRESSION, clazz, info);
        if (syntaxes == null) {
            return;
        }
        Class returnClazz = Register.getExpressionReturnType(clazz);
        if (returnClazz == null) {
            Umbaska.logFail(Umbaska.debug ? null : clazz, "Couldn't register this PropertyExpression because the returnClazz is null");
        }
        Skript.registerExpression(clazz, (Class)returnClazz, (ExpressionType)ExpressionType.PROPERTY, (String[])syntaxes.value());
    }

    private static Syntaxes validateAndGenerateDocs(SyntaxElement element, Class<?> clazz, Class<?> info) {
        Integer result = Register.validateAndGenerateDocsInner(element, clazz, info);
        Syntaxes syntaxes = info.getAnnotation(Syntaxes.class);
        if (generateDocs && (result == 0 || result == 1)) {
            Name name = info.getAnnotation(Name.class);
            if (name == null || name.value().isEmpty()) {
                Umbaska.logDocs(Umbaska.debug ? null : clazz, "WARNING > The Name annotation of this ", element.toString(), " is ", name == null ? "not set" : "empty", ", so it won't be added to the documentation");
            } else {
                String urlName = "";
                String urlSyntax = "";
                for (String syntax : syntaxes.value()) {
                    urlSyntax = "||" + urlSyntax + syntax;
                }
                urlSyntax = urlSyntax.substring(2, urlSyntax.length());
                try {
                    urlName = URLEncoder.encode(info.getAnnotation(Name.class).value(), "UTF-8");
                    urlSyntax = URLEncoder.encode(urlSyntax, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                String args = "?type=" + element.getDocsURLName() + "&name=" + urlName + "&syntax=" + urlSyntax;
                if (!docList.contains(args)) {
                    docList.add(args);
                    Umbaska.logDocs(Umbaska.debug ? null : clazz, "Added to array: ", args);
                } else {
                    Umbaska.logDocs(Umbaska.debug ? null : clazz, "The array already contained: ", args);
                }
            }
        }
        if (result == 0) {
            registeredAmount.put(element, registeredAmount.get((Object)element) + 1);
            return syntaxes;
        }
        if (result == 2) {
            failedAmount.put(element, failedAmount.get((Object)element) + 1);
        }
        return null;
    }

    protected static Integer validateAndGenerateDocsInner(SyntaxElement element, Class<?> clazz, Class<?> info) {
        Name name = info.getAnnotation(Name.class);
        Syntaxes syntaxes = info.getAnnotation(Syntaxes.class);
        DontRegister dontRegister = clazz.getAnnotation(DontRegister.class);
        Dependency dependency = info.getAnnotation(Dependency.class);
        AtLeast atLeast = info.getAnnotation(AtLeast.class);
        if (dontRegister != null) {
            Umbaska.logDebug(clazz, "Detected annotation DontRegister. Aborting.");
            return 1;
        }
        String clazzName = clazz.getName();
        if (Version.parse(clazzName.substring(clazzName.length() - 8, clazzName.length() - 6)) != null) {
            Umbaska.logDebug(clazz, "This class is only for one MC version, and should have been already registered before");
            return 1;
        }
        if (atLeast != null && !Version.isAtLeast(atLeast)) {
            Umbaska.logDebug(clazz, new Object[]{"This element requires Minecraft server core version greater than ", atLeast.value(), " while your is ", Version.serverVersion});
            return 1;
        }
        if (dependency != null && (plugin = pluginManager.getPlugin(dependency.value())) == null) {
            Umbaska.logDebug("Couldn't register this ", element.toString(), " because the dependency ", dependency.value(), " cannot be resolved");
            return 1;
        }
        if (syntaxes == null) {
            if (name == null) {
                Umbaska.logFail(Umbaska.debug ? null : clazz, "Couldn't register this ", element.toString(), " because the Syntaxes annotation is null");
            } else {
                Umbaska.logFail(Umbaska.debug ? null : clazz, "Couldn't register this ", element.toString(), " with name ", name.value(), " because the Syntaxes annotation is null");
            }
            return 2;
        }
        int i = 0;
        for (String syntax : syntaxes.value()) {
            if (++i <= 1) {
                Umbaska.logDebug("With Syntax: ", syntax);
                continue;
            }
            Umbaska.logDebug("And: ", syntax);
        }
        return 0;
    }

    public static boolean tryGenerateDocs(String givenPassword, CommandSender sender, final String urlStart) {
        try {
            if (!DocsPassword.checkDevPassword(givenPassword)) {
                return false;
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        if (sender instanceof Player) {
            sender.sendMessage(ChatColor.YELLOW + "Okay, check the console.");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Umbaska.get(), new Runnable(){

            @Override
            public void run() {
                for (String s : docList) {
                    try {
                        URL verUrl = new URL(urlStart + s);
                        Umbaska.logDocs("Opening URL: " + verUrl);
                        HttpURLConnection httpCon = (HttpURLConnection)verUrl.openConnection();
                        httpCon.setRequestProperty("User-Agent", "Mozilla/5.0");
                        InputStream inputStream = httpCon.getInputStream();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        Umbaska.logDocs("The response from server is: ", bufferedReader.readLine());
                        inputStream.close();
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        if (e.getCause() != null) {
                            Umbaska.logDocs("Caught an IOException: ", e.getCause().getMessage());
                            continue;
                        }
                        Umbaska.logDocs("Caught an IOException:");
                        e.printStackTrace();
                    }
                }
            }
        });
        return true;
    }

    private static Class getExpressionReturnType(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getReturnType", new Class[0]);
            Object o = clazz.newInstance();
            Object returnType = method.invoke(o, new Object[0]);
            return (Class)returnType;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        docList = new ArrayList();
        pluginManager = Bukkit.getPluginManager();
        registeredAmount = new HashMap();
        failedAmount = new HashMap();
    }
}

