/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.ParticleProjectiles;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import uk.co.umbaska.Enums.ParticleEnum_V1_9_R1;
import uk.co.umbaska.ParticleProjectiles.BoundingBox;
import uk.co.umbaska.ParticleProjectiles.ParticleProjectileHitEvent;
import uk.co.umbaska.ParticleProjectiles.ParticleProjectileLandEvent;
import uk.co.umbaska.ParticleProjectiles.ProjectileType;
import uk.co.umbaska.ParticleProjectiles.UmbError;
import uk.co.umbaska.Replacers.ParticleFunction_V1_9_R1;
import uk.co.umbaska.Umbaska;

public class ParticleProjectile {
    String name;
    ParticleEnum_V1_9_R1 particleType;
    Vector vector;
    Location startLocation;
    Location currentLocation;
    Double xoff;
    Double yoff;
    Double zoff;
    Double gravity;
    Integer count = 25;
    Integer particleData1 = 0;
    Integer particleData2 = 0;
    Integer particleSpeed = 0;
    ProjectileType type;
    Boolean running = false;
    Boolean paused = false;
    Boolean pausedInPlace = false;
    BoundingBox boundingBox;
    ProjectileTracker projectileTracker;
    int ticksPerSecond = 20;

    public ParticleProjectile(ParticleEnum_V1_9_R1 particleType, String name) {
        this.particleType = particleType;
        this.running = false;
        this.name = name;
    }

    public void start() throws UmbError {
        if (this.startLocation == null) {
            throw new UmbError("Start Location not provided");
        }
        if (this.isRunning()) {
            throw new UmbError("Already running");
        }
        this.running = true;
        this.boundingBox = new BoundingBox(this.getStartLocation(), (double)this.getXoff(), (double)this.getYoff());
        this.currentLocation = this.getStartLocation();
        this.projectileTracker = new ProjectileTracker();
        this.projectileTracker.run();
    }

    public void stop() {
        this.running = false;
        this.projectileTracker.task.cancel();
    }

    public void pause() {
        if (this.isRunning()) {
            this.paused = true;
            this.pausedInPlace = false;
        }
    }

    public void unpause() {
        if (this.isRunning()) {
            this.paused = false;
            this.pausedInPlace = false;
        }
    }

    public void pause(Boolean inPlace) {
        if (this.isRunning()) {
            this.paused = true;
            this.pausedInPlace = inPlace;
        }
    }

    public int getTicksPerSecond() {
        return this.ticksPerSecond;
    }

    public ProjectileType getType() {
        return this.type;
    }

    public void setType(ProjectileType type) {
        this.type = type;
    }

    public void setTicksPerSecond(int ticksPerSecond) {
        this.ticksPerSecond = ticksPerSecond;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setStartLocation(Location location) {
        this.startLocation = location;
    }

    public void setParticleType(ParticleEnum_V1_9_R1 particleType) {
        this.particleType = particleType;
    }

    public void setOffset(Double xoff, Double yoff, Double zoff) {
        this.xoff = xoff;
        this.yoff = yoff;
        this.zoff = zoff;
    }

    public void setParticleCount(Integer count) {
        this.count = count;
    }

    public void setVector(Vector v) {
        this.vector = v;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public ParticleEnum_V1_9_R1 getParticleType() {
        return this.particleType;
    }

    public void setCurrentLocation(Location l) {
        this.currentLocation = l;
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    public Vector getVector() {
        return this.vector;
    }

    public Integer getCount() {
        return this.count;
    }

    public Double getXoff() {
        return this.xoff;
    }

    public Double getYoff() {
        return this.yoff;
    }

    public Double getZoff() {
        return this.zoff;
    }

    public Integer getParticleData1() {
        return this.particleData1;
    }

    public void setParticleData1(Integer particleData1) {
        this.particleData1 = particleData1;
    }

    public Integer getParticleData2() {
        return this.particleData2;
    }

    public void setParticleData2(Integer particleData2) {
        this.particleData2 = particleData2;
    }

    public Integer getParticleSpeed() {
        return this.particleSpeed;
    }

    public void setParticleSpeed(Integer particleSpeed) {
        this.particleSpeed = particleSpeed;
    }

    private class ProjectileTracker
    implements Runnable {
        List<LivingEntity> entities;
        BukkitTask task;

        public ProjectileTracker() {
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)Umbaska.get(), (Runnable)this, (long)ParticleProjectile.this.getTicksPerSecond(), (long)ParticleProjectile.this.getTicksPerSecond());
        }

        @Override
        public void run() {
            if (ParticleProjectile.this.isRunning()) {
                if (!ParticleProjectile.this.paused.booleanValue()) {
                    this.spawnParticles();
                    ParticleProjectile.this.boundingBox = new BoundingBox(ParticleProjectile.this.getStartLocation(), (double)ParticleProjectile.this.getXoff(), (double)ParticleProjectile.this.getYoff());
                    ParticleProjectile.this.currentLocation.add(ParticleProjectile.this.getVector());
                    if (ParticleProjectile.this.getGravity() > 0.0) {
                        ParticleProjectile.this.setVector(ParticleProjectile.this.getVector().setY(ParticleProjectile.this.getVector().getY() - ParticleProjectile.this.getGravity() / (double)ParticleProjectile.this.ticksPerSecond));
                    }
                    if (ParticleProjectile.this.currentLocation.getBlock().getType() != Material.AIR && (ParticleProjectile.this.type == ProjectileType.STOP_ON_GROUND || ParticleProjectile.this.type == ProjectileType.STOP_ON_BOTH)) {
                        ParticleProjectileLandEvent land = new ParticleProjectileLandEvent(ParticleProjectile.this.currentLocation, ParticleProjectile.this.name);
                        Bukkit.getServer().getPluginManager().callEvent((Event)land);
                        if (!land.isCancelled()) {
                            ParticleProjectile.this.running = false;
                            ParticleProjectile.this.stop();
                        }
                    }
                    this.entities = ParticleProjectile.this.currentLocation.getWorld().getLivingEntities();
                    boolean stop = false;
                    for (LivingEntity le : this.entities) {
                        if (!(le.getLocation().distanceSquared(ParticleProjectile.this.currentLocation) < 2.2) && !ParticleProjectile.this.boundingBox.contains((Entity)le)) continue;
                        ParticleProjectileHitEvent land = new ParticleProjectileHitEvent((Entity)le, ParticleProjectile.this.name);
                        Bukkit.getServer().getPluginManager().callEvent((Event)land);
                        stop = !land.isCancelled();
                    }
                    if ((ParticleProjectile.this.type == ProjectileType.STOP_ON_HIT || ParticleProjectile.this.type == ProjectileType.STOP_ON_BOTH) && stop) {
                        ParticleProjectile.this.running = false;
                        ParticleProjectile.this.stop();
                    }
                    this.spawnParticles();
                } else if (ParticleProjectile.this.pausedInPlace.booleanValue()) {
                    this.spawnParticles();
                }
            }
        }

        public void spawnParticles() {
            ParticleFunction_V1_9_R1.spawnParticle(ParticleProjectile.this.getCount(), ParticleProjectile.this.getParticleType(), ParticleProjectile.this.getParticleSpeed(), ParticleProjectile.this.getXoff(), ParticleProjectile.this.getYoff(), ParticleProjectile.this.getZoff(), new Location[]{ParticleProjectile.this.getCurrentLocation()}, ParticleProjectile.this.getParticleData1());
        }
    }
}

