/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Managers;

import ch.njol.skript.ScriptLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class FileManager {
    public void loadScripts(String folder) {
        File in = new File(folder);
        ScriptLoader.loadScripts((File)in);
    }

    public void createFile(String file) {
        File f = new File(file);
        if (f.exists()) {
            return;
        }
        try {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException s) {
            s.printStackTrace();
        }
    }

    public void deleteFile(String file) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        f.delete();
    }

    public String[] unrecursiveFileListing(String file) {
        ArrayList<String> files = new ArrayList<String>();
        File folder = new File(file);
        for (File fileEntry : folder.listFiles()) {
            files.add(fileEntry.getName());
        }
        if (files.size() > 0) {
            String[] out = new String[files.size()];
            out = files.toArray(out);
            return out;
        }
        return null;
    }

    public String[] recursiveFileListing(String file) {
        ArrayList<String> files = new ArrayList<String>();
        File folder = new File(file);
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                for (String secondFile : this.recursiveFileListing(fileEntry.getPath())) {
                    System.out.println(secondFile);
                }
            }
            files.add(fileEntry.getName());
        }
        if (files.size() > 0) {
            String[] out = new String[files.size()];
            out = files.toArray(out);
            return out;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineOfFile(String file, String text, Integer l) throws IOException {
        String line;
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        if (l < 0) {
            return;
        }
        l = l - 1;
        ArrayList<String> sss = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            sss.add(line);
        }
        br.close();
        String[] out = new String[sss.size()];
        out = sss.toArray(out);
        out[l.intValue()] = text;
        f.delete();
        f.createNewFile();
        for (String write : out) {
            this.writeToFile(file, write, false);
        }
    }

    public String getLineOfFile(String file, Integer l) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        if (l < 0) {
            return null;
        }
        l = l - 1;
        ArrayList<String> sss = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                sss.add(line);
            }
        }
        String[] out = new String[sss.size()];
        out = sss.toArray(out);
        return out[l];
    }

    public String[] getLinesOfFile(String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        ArrayList<String> sss = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                sss.add(line);
            }
        }
        String[] out = new String[sss.size()];
        out = sss.toArray(out);
        return out;
    }

    public void writeToFile(String file, String text, Boolean overwrite) {
        if (this.fileExists(file)) {
            BufferedWriter output = null;
            try {
                output = overwrite.booleanValue() ? new BufferedWriter(new FileWriter(file, (boolean)overwrite)) : new BufferedWriter(new FileWriter(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                output.append(text + System.getProperty("line.separator"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ((Writer)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean fileExists(String file) {
        File f = new File(file);
        return f.exists();
    }
}

