/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import uk.co.umbaska.Umbaska;

public class Debugger {
    private PrintStream ps;
    private Boolean log;
    private Umbaska umbaska;
    Calendar calendar = Calendar.getInstance();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");

    public Debugger(Umbaska umbaska, Boolean log) {
        this.umbaska = umbaska;
        this.log = log;
        if (log.booleanValue()) {
            try {
                File file = new File(umbaska.getDataFolder(), "oldlog.txt");
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.ps = new PrintStream(new FileOutputStream(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void debug(String debug) {
        this.umbaska.getLogger().info(debug);
        if (this.log.booleanValue()) {
            Date date = this.calendar.getTime();
            this.ps.println(this.simpleDateFormat.format(date) + ": " + debug);
        }
    }

    public void close() {
        if (this.log.booleanValue()) {
            this.ps.close();
        }
    }
}

