/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.VaultEcon;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import uk.co.umbaska.VaultEcon.EconPlayer;
import uk.co.umbaska.VaultEcon.VaultHandler;

public class EconMain
implements Listener {
    private static Plugin p;
    private static EconMain instance;
    private Economy econ;
    private String version = "1.0";
    private FileConfiguration customConfig = null;
    private File customConfigFile = null;
    private VaultHandler handler;
    private String currencySymbol;
    private Double startingbalance;
    private Double minBalance;
    private Double maxbalance;

    public EconMain(Plugin p) {
        EconMain.p = p;
        this.handler = new VaultHandler(this);
        Bukkit.getPluginManager().registerEvents((Listener)this, p);
        p.getDataFolder().mkdirs();
        File file = new File(p.getDataFolder() + "/Econ/base.yml");
        Boolean created = false;
        try {
            created = file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!created.booleanValue()) {
            p.getLogger().warning("Could not create Base.YML within the Users Folder. Oops.");
        }
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(p.getDataFolder() + "/Econ/config.yml");
        }
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
        if (!this.customConfig.getString("economy-version").equalsIgnoreCase(this.version)) {
            p.getLogger().warning("Economy Config is out of date. Recreating it.");
            try {
                InputStreamReader defConfigStream = new InputStreamReader(p.getResource("Econ/config.yml"), "UTF8");
                if (defConfigStream != null) {
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                    this.customConfig.setDefaults((Configuration)defConfig);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.saveConfig();
        }
        this.startingbalance = this.customConfig.getDouble("starting-balance");
        this.minBalance = this.customConfig.getDouble("minimum-balance-allowed");
        this.maxbalance = this.customConfig.getDouble("maximum-balance-allowed");
        if (this.maxbalance == -1.0) {
            this.maxbalance = Double.POSITIVE_INFINITY;
        }
        if (this.minBalance == -1.0) {
            this.minBalance = Double.NEGATIVE_INFINITY;
        }
        if (!created.booleanValue()) {
            p.getLogger().warning("Could not create Base.YML within the Users Folder. Oops.");
        }
        if (!this.setupEconomy()) {
            p.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", "Umbaska Vault Economy Hook"));
            return;
        }
    }

    @EventHandler
    public void onJoinSetup(PlayerJoinEvent e) {
        this.setupPlayerData(e.getPlayer());
    }

    public Double getMinBalance() {
        return this.minBalance;
    }

    public Double getMaxbalance() {
        return this.maxbalance;
    }

    public Double getStartingbalance() {
        return this.startingbalance;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public static Plugin getP() {
        return p;
    }

    public static EconMain getInstance() {
        return instance;
    }

    public Economy getEcon() {
        return this.econ;
    }

    public String getVersion() {
        return this.version;
    }

    private void saveConfig() {
        try {
            this.customConfig.save(this.customConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean setupEconomy() {
        if (p.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = p.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    private void setupPlayerData(Player p) {
        new EconPlayer(p);
    }

    public EconPlayer getPlayer(UUID uuid) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
        return EconPlayer.getEconPlayer(op);
    }

    public EconPlayer getPlayer(OfflinePlayer op) {
        return EconPlayer.getEconPlayer(op);
    }

    public EconPlayer getAccount(String playerName, String uuid) {
        return this.getPlayer(UUID.fromString(uuid));
    }
}

