/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils.Disguise.DisguiseUTIL;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.server.v1_8_R1.EntityHuman;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.EnumPlayerInfoAction;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityLook;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R1.PacketPlayOutHeldItemSlot;
import net.minecraft.server.v1_8_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_8_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R1.PacketPlayOutRelEntityMoveLook;
import net.minecraft.server.v1_8_R1.PlayerConnection;
import net.minecraft.server.v1_8_R1.PlayerInteractManager;
import net.minecraft.server.v1_8_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.Disguise;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.UUIDRetriever;

public class PlayerDisguise_V1_8_R1
extends Disguise {
    private String name;
    private EntityPlayer ep;

    public PlayerDisguise_V1_8_R1(Entity p, String name) {
        super(p, EntityType.PLAYER);
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
    }

    @Override
    public void applyDisguise(Collection<Player> players) {
        UUID uid = new UUIDRetriever(this.name).getUUID();
        GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, this.name);
        UUIDRetriever.setSkin(gp);
        EntityPlayer playerEntity = ((CraftPlayer)this.getPlayer()).getHandle();
        EntityPlayer ep = this.ep == null ? (this.ep = new EntityPlayer(playerEntity.server, (WorldServer)playerEntity.world, gp, new PlayerInteractManager(playerEntity.world))) : this.ep;
        ep.inventory = playerEntity.inventory;
        ep.locX = playerEntity.locX;
        ep.locY = playerEntity.locY;
        ep.locZ = playerEntity.locZ;
        ep.yaw = playerEntity.yaw;
        ep.pitch = playerEntity.pitch;
        PacketPlayOutEntityDestroy destroy = new PacketPlayOutEntityDestroy(new int[]{playerEntity.getId()});
        PacketPlayOutPlayerInfo infoRemove = new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{playerEntity});
        PacketPlayOutPlayerInfo infoAdd = new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{ep});
        PacketPlayOutNamedEntitySpawn spawn = new PacketPlayOutNamedEntitySpawn((EntityHuman)ep);
        for (Player p : players) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            PlayerConnection pc = aep.playerConnection;
            pc.sendPacket((Packet)destroy);
            pc.sendPacket((Packet)infoRemove);
            pc.sendPacket((Packet)infoAdd);
            pc.sendPacket((Packet)spawn);
        }
    }

    @Override
    public void revertDisguise(Collection<Player> players) {
        EntityPlayer playerEntity = ((CraftPlayer)this.getPlayer()).getHandle();
        PacketPlayOutEntityDestroy destroy = new PacketPlayOutEntityDestroy(new int[]{this.ep.getId()});
        PacketPlayOutPlayerInfo infoRemove = new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{this.ep});
        PacketPlayOutPlayerInfo infoAdd = new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{playerEntity});
        PacketPlayOutNamedEntitySpawn spawn = new PacketPlayOutNamedEntitySpawn((EntityHuman)playerEntity);
        for (Player p : players) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            PlayerConnection pc = aep.playerConnection;
            pc.sendPacket((Packet)destroy);
            pc.sendPacket((Packet)infoRemove);
            pc.sendPacket((Packet)infoAdd);
            pc.sendPacket((Packet)spawn);
        }
    }

    public void sneak(boolean sneak) {
        this.ep.setSneaking(sneak);
        PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(this.ep.getId(), this.ep.getDataWatcher(), true);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            aep.playerConnection.sendPacket((Packet)meta);
        }
    }

    public void swingArm() {
        PacketPlayOutAnimation animation = new PacketPlayOutAnimation((net.minecraft.server.v1_8_R1.Entity)this.ep, 0);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            aep.playerConnection.sendPacket((Packet)animation);
        }
    }

    public void setItemInHand(int slot) {
        PacketPlayOutHeldItemSlot held = new PacketPlayOutHeldItemSlot(slot);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            aep.playerConnection.sendPacket((Packet)held);
        }
    }

    @Override
    public void move(Location old, Location newloc) {
        PacketPlayOutRelEntityMoveLook moveLook = new PacketPlayOutRelEntityMoveLook(this.ep.getId(), (byte)((newloc.getBlockX() - old.getBlockX()) * 32), (byte)((newloc.getBlockY() - old.getBlockY()) * 32), (byte)((newloc.getBlockZ() - old.getBlockZ()) * 32), 0, 0, this.ep.getBukkitEntity().isOnGround());
        PacketPlayOutEntityLook look = new PacketPlayOutEntityLook(this.ep.getId(), (byte)(newloc.getYaw() * 256.0f / 360.0f), (byte)(newloc.getPitch() * 256.0f / 360.0f), this.ep.getBukkitEntity().isOnGround());
        PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation((net.minecraft.server.v1_8_R1.Entity)this.ep, (byte)(newloc.getYaw() * 256.0f / 360.0f));
        this.ep.yaw = newloc.getYaw();
        this.ep.pitch = newloc.getPitch();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p == this.getPlayer()) continue;
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            aep.playerConnection.sendPacket((Packet)moveLook);
            aep.playerConnection.sendPacket((Packet)look);
            aep.playerConnection.sendPacket((Packet)rotation);
        }
    }

    public String getName() {
        return this.name;
    }
}

