/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils.Disguise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import uk.co.umbaska.Main;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.Disguise;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.PlayerDisguise_V1_8_R3;

public class DisguiseAPI_V1_8_R3 {
    private static DisguiseAPI_V1_8_R3 api = new DisguiseAPI_V1_8_R3();
    private Set<Disguise> disguises = new HashSet<Disguise>();
    private JavaPlugin plugin;

    public static DisguiseAPI_V1_8_R3 getAPI() {
        return api;
    }

    public void initialize(final JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onRespawn(PlayerRespawnEvent e) {
                new BukkitRunnable(){

                    public void run() {
                        ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).refresh();
                    }
                }.runTaskLater((Plugin)plugin, 1L);
            }

            @EventHandler
            public void onDeath(final EntityDeathEvent e) {
                new BukkitRunnable(){

                    public void run() {
                        if (((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)e.getEntity()) == null) {
                            return;
                        }
                        ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).unDisguisePlayer((Entity)e.getEntity());
                    }
                }.runTaskLater((Plugin)plugin, 1L);
            }

            @EventHandler
            public void onMove(PlayerMoveEvent e) {
                Player p = e.getPlayer();
                if (DisguiseAPI_V1_8_R3.this.getDisguise((Entity)p) == null) {
                    return;
                }
                Disguise dis = ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p);
                dis.move(e.getFrom(), e.getTo());
            }

            @EventHandler
            public void onQuit(PlayerQuitEvent e) {
                final Player p = e.getPlayer();
                for (final Disguise d : DisguiseAPI_V1_8_R3.this.disguises) {
                    new BukkitRunnable(){

                        public void run() {
                            d.revertDisguise(Arrays.asList(p));
                        }
                    }.runTaskLater((Plugin)plugin, 1L);
                }
                if (((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p) == null) {
                    return;
                }
                Disguise d = ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p);
                d.revertDisguise(DisguiseAPI_V1_8_R3.this.online());
                DisguiseAPI_V1_8_R3.this.disguises.remove(d);
            }

            @EventHandler
            public void onJoin(PlayerJoinEvent e) {
                final Player p = e.getPlayer();
                for (final Disguise d : DisguiseAPI_V1_8_R3.this.disguises) {
                    new BukkitRunnable(){

                        public void run() {
                            d.applyDisguise(Arrays.asList(p));
                        }
                    }.runTaskLater((Plugin)plugin, 1L);
                }
            }

            @EventHandler
            public void onHoldItem(PlayerItemHeldEvent e) {
                Player p = e.getPlayer();
                if (((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p) == null) {
                    return;
                }
                Disguise dis = ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p);
                if (!(dis instanceof PlayerDisguise_V1_8_R3)) {
                    return;
                }
                PlayerDisguise_V1_8_R3 pd = (PlayerDisguise_V1_8_R3)dis;
                pd.setItemInHand(e.getNewSlot());
            }

            @EventHandler
            public void onInteract(PlayerInteractEvent e) {
                if (e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK) {
                    return;
                }
                Player p = e.getPlayer();
                if (((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p) == null) {
                    return;
                }
                Disguise dis = ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p);
                if (!(dis instanceof PlayerDisguise_V1_8_R3)) {
                    return;
                }
                PlayerDisguise_V1_8_R3 pd = (PlayerDisguise_V1_8_R3)dis;
                pd.swingArm();
            }

            @EventHandler
            public void onSneak(PlayerToggleSneakEvent e) {
                Player p = e.getPlayer();
                if (((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p) == null) {
                    return;
                }
                Disguise dis = ((DisguiseAPI_V1_8_R3)Main.disguiseAPI).getDisguise((Entity)p);
                if (!(dis instanceof PlayerDisguise_V1_8_R3)) {
                    return;
                }
                PlayerDisguise_V1_8_R3 pd = (PlayerDisguise_V1_8_R3)dis;
                pd.sneak(e.isSneaking());
            }
        }, (Plugin)plugin);
    }

    public List<Entity> getDisguised() {
        ArrayList<Entity> s = new ArrayList<Entity>();
        for (Disguise d : this.disguises) {
            s.add(d.getPlayer());
        }
        return s;
    }

    public boolean isDisguised(Entity p) {
        for (Disguise d : this.disguises) {
            if (!d.getPlayer().equals(p)) continue;
            return true;
        }
        return false;
    }

    public Disguise getDisguise(Entity p) {
        for (Disguise d : this.disguises) {
            if (!d.getPlayer().getUniqueId().toString().equals(p.getUniqueId().toString())) continue;
            return d;
        }
        return null;
    }

    public void unDisguisePlayer(Entity p) {
        if (!this.isDisguised(p)) {
            return;
        }
        this.getDisguise(p).revertDisguise(this.online());
        this.disguises.remove(this.getDisguise(p));
    }

    public Collection<Player> online() {
        return new ArrayList<Player>(Bukkit.getServer().getOnlinePlayers());
    }

    public void disguisePlayer(Entity p, Disguise d, Collection<Player> players) {
        if (this.isDisguised(p)) {
            return;
        }
        d.applyDisguise(players);
        this.disguises.add(d);
    }

    public void disguisePlayer(Entity p, Disguise d) {
        this.disguisePlayer(p, d, this.online());
    }

    public void refresh() {
        for (Disguise d : this.disguises) {
            this.refresh(d.getPlayer());
        }
    }

    private void refresh(Entity p) {
        final Disguise d = this.getDisguise(p);
        new BukkitRunnable(){

            public void run() {
                d.revertDisguise(DisguiseAPI_V1_8_R3.this.online());
                d.applyDisguise(DisguiseAPI_V1_8_R3.this.online());
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }
}

