/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.VaultEcon;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import uk.co.umbaska.VaultEcon.EconMain;

public class EconPlayer {
    private static HashMap<OfflinePlayer, EconPlayer> econPlayerHashMap = new HashMap();
    private OfflinePlayer player;
    private FileConfiguration customConfig = null;
    private File customConfigFile = null;
    private Double balance;

    public static EconPlayer getEconPlayer(OfflinePlayer p) {
        if (econPlayerHashMap.containsKey(p)) {
            return econPlayerHashMap.get(p);
        }
        return new EconPlayer(p);
    }

    public EconPlayer(Player p) {
        new EconPlayer((OfflinePlayer)p);
    }

    public EconPlayer(OfflinePlayer p) {
        this.player = p;
        econPlayerHashMap.put(p, this);
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(EconMain.getP().getDataFolder() + "/Econ/" + p.getUniqueId().toString() + ".yml");
        }
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
        this.balance = EconMain.getInstance().getStartingbalance();
        this.saveConfig();
    }

    private void saveConfig() {
        try {
            this.customConfig.save(this.customConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Double getBalance() {
        return this.balance;
    }

    public Double addBalance(Double amt) {
        this.balance = this.getBalance() + amt > EconMain.getInstance().getMaxbalance() ? EconMain.getInstance().getMaxbalance() : Double.valueOf(this.getBalance() + amt);
        this.saveData();
        return this.getBalance();
    }

    public Boolean removeBalance(Double amt) {
        if (this.getBalance() - amt < EconMain.getInstance().getMinBalance()) {
            this.balance = EconMain.getInstance().getMinBalance();
            return false;
        }
        this.balance = this.getBalance() - amt;
        this.saveData();
        return true;
    }

    public Boolean has(Double amt) {
        return this.getBalance() >= amt;
    }

    public void saveData() {
        this.customConfig.set("balance", (Object)this.balance);
        this.saveConfig();
    }
}

