/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.ProtocolLib;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutHeldItemSlot;
import net.minecraft.server.v1_8_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PlayerConnection;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.UUIDRetriever;

public class FakePlayerTracker_R3 {
    public static HashMap<String, EntityPlayer> playertracker = new HashMap();
    public static HashMap<String, String> displaynameholder = new HashMap();
    public static HashMap<String, String> skinholder = new HashMap();

    public static Boolean registerNewPlayer(String id) {
        if (playertracker.containsKey(id)) {
            return false;
        }
        UUID uid = new UUIDRetriever(id).getUUID();
        GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, id);
        UUIDRetriever.setSkin(gp);
        EntityPlayer newPlayer = new EntityPlayer(MinecraftServer.getServer(), (WorldServer)MinecraftServer.getServer().getWorld(), gp, new PlayerInteractManager(MinecraftServer.getServer().getWorld()));
        playertracker.put(id, newPlayer);
        displaynameholder.put(id, id);
        skinholder.put(id, id);
        FakePlayerTracker_R3.start(id);
        return true;
    }

    public static EntityPlayer getPlayer(String id) {
        if (playertracker.containsKey(id)) {
            return playertracker.get(id);
        }
        return null;
    }

    public static String getDisName(String id) {
        if (displaynameholder.containsKey(id)) {
            return displaynameholder.get(id);
        }
        return null;
    }

    public static String getSkin(String id) {
        if (skinholder.containsKey(id)) {
            return skinholder.get(id);
        }
        return null;
    }

    public static void setDisplayName(String id, String value) {
        EntityPlayer p = FakePlayerTracker_R3.getPlayer(id);
        if (p != null) {
            UUID uid = new UUIDRetriever(FakePlayerTracker_R3.getSkin(id)).getUUID();
            GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, value);
            UUIDRetriever.setSkin(gp);
            EntityPlayer newPlayer = new EntityPlayer(MinecraftServer.getServer(), (WorldServer)MinecraftServer.getServer().getWorld(), gp, new PlayerInteractManager(MinecraftServer.getServer().getWorld()));
            newPlayer.setLocation(p.locX, p.locY, p.locZ, p.pitch, p.yaw);
            newPlayer.world = p.getWorld();
            newPlayer.inventory = p.inventory;
            newPlayer.displayName = p.displayName;
            newPlayer.setHealth(p.getHealth());
            playertracker.remove(id);
            playertracker.put(id, newPlayer);
            displaynameholder.put(id, value);
            FakePlayerTracker_R3.refresh(p, newPlayer);
        }
    }

    public static void setSkin(String id, String value) {
        EntityPlayer p = FakePlayerTracker_R3.getPlayer(id);
        if (p != null) {
            UUID uid = new UUIDRetriever(value).getUUID();
            GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, FakePlayerTracker_R3.getDisName(id));
            UUIDRetriever.setSkin(gp);
            EntityPlayer newPlayer = new EntityPlayer(MinecraftServer.getServer(), (WorldServer)MinecraftServer.getServer().getWorld(), gp, new PlayerInteractManager(MinecraftServer.getServer().getWorld()));
            newPlayer.setLocation(p.locX, p.locY, p.locZ, p.pitch, p.yaw);
            newPlayer.world = p.getWorld();
            newPlayer.inventory = p.inventory;
            newPlayer.displayName = p.displayName;
            newPlayer.setHealth(p.getHealth());
            playertracker.remove(id);
            playertracker.put(id, newPlayer);
            skinholder.put(id, value);
            FakePlayerTracker_R3.refresh(p, newPlayer);
        }
    }

    public static Boolean isSneaking(String id) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            return ep.isSneaking();
        }
        return false;
    }

    public static void sneak(String id, boolean sneak) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            ep.setSneaking(sneak);
            PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(ep.getId(), ep.getDataWatcher(), true);
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)meta);
            }
        }
    }

    public static void swingArm(String id) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            PacketPlayOutAnimation animation = new PacketPlayOutAnimation((Entity)ep, 0);
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)animation);
            }
        }
    }

    public static void setItemInHand(String id, int slot) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            PacketPlayOutHeldItemSlot held = new PacketPlayOutHeldItemSlot(slot);
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)held);
            }
        }
    }

    public static void move(String id, Location newloc) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            Location loc = new Location((org.bukkit.World)ep.getWorld().getWorld(), ep.locX, ep.locY, ep.locX);
            FakePlayerTracker_R3.move(id, loc, newloc);
        }
    }

    public static void move(String id, Location old, Location newloc) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook moveLook = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(ep.getId(), (byte)((newloc.getBlockX() - old.getBlockX()) * 32), (byte)((newloc.getBlockY() - old.getBlockY()) * 32), (byte)((newloc.getBlockZ() - old.getBlockZ()) * 32), 0, 0, ep.getBukkitEntity().isOnGround());
            PacketPlayOutEntity.PacketPlayOutEntityLook look = new PacketPlayOutEntity.PacketPlayOutEntityLook(ep.getId(), (byte)(newloc.getYaw() * 256.0f / 360.0f), (byte)(newloc.getPitch() * 256.0f / 360.0f), ep.getBukkitEntity().isOnGround());
            PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation((Entity)ep, (byte)(newloc.getYaw() * 256.0f / 360.0f));
            ep.yaw = newloc.getYaw();
            ep.pitch = newloc.getPitch();
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)moveLook);
                aep.playerConnection.sendPacket((Packet)look);
                aep.playerConnection.sendPacket((Packet)rotation);
            }
        }
    }

    public static void teleport(String id, Location newloc) {
        EntityPlayer ep = FakePlayerTracker_R3.getPlayer(id);
        if (ep != null) {
            ep.setLocation(newloc.getX(), newloc.getY(), newloc.getZ(), newloc.getPitch(), newloc.getYaw());
            ep.world = (World)newloc.getWorld();
            PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport(ep.getId(), (int)newloc.getX() * 32, (int)newloc.getY() * 32, (int)newloc.getZ() * 32, (byte)newloc.getYaw(), (byte)newloc.getPitch(), ep.onGround);
            ep.yaw = newloc.getYaw();
            ep.pitch = newloc.getPitch();
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)teleport);
            }
        }
    }

    public static void refresh(EntityPlayer old, EntityPlayer newp) {
        PacketPlayOutEntityDestroy destroy = new PacketPlayOutEntityDestroy(new int[]{old.getId()});
        PacketPlayOutPlayerInfo infoRemove = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{old});
        PacketPlayOutPlayerInfo infoAdd = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{newp});
        PacketPlayOutNamedEntitySpawn spawn = new PacketPlayOutNamedEntitySpawn((EntityHuman)newp);
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            PlayerConnection pc = aep.playerConnection;
            pc.sendPacket((Packet)destroy);
            pc.sendPacket((Packet)infoRemove);
            pc.sendPacket((Packet)infoAdd);
            pc.sendPacket((Packet)spawn);
        }
    }

    public static void start(String id) {
        PacketPlayOutPlayerInfo infoAdd = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{FakePlayerTracker_R3.getPlayer(id)});
        PacketPlayOutNamedEntitySpawn spawn = new PacketPlayOutNamedEntitySpawn((EntityHuman)FakePlayerTracker_R3.getPlayer(id));
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            EntityPlayer aep = ((CraftPlayer)p).getHandle();
            PlayerConnection pc = aep.playerConnection;
            pc.sendPacket((Packet)infoAdd);
            pc.sendPacket((Packet)spawn);
        }
    }
}

