/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.ProtocolLib;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.v1_8_R1.Entity;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.MinecraftServer;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityLook;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R1.PacketPlayOutHeldItemSlot;
import net.minecraft.server.v1_8_R1.PacketPlayOutRelEntityMoveLook;
import net.minecraft.server.v1_8_R1.PlayerInteractManager;
import net.minecraft.server.v1_8_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import uk.co.umbaska.Utils.Disguise.DisguiseUTIL.UUIDRetriever;

public class FakePlayerTracker_R1 {
    public static HashMap<String, EntityPlayer> playertracker = new HashMap();
    public static HashMap<String, String> displaynameholder = new HashMap();
    public static HashMap<String, String> skinholder = new HashMap();

    public static Boolean registerNewPlayer(String id) {
        if (playertracker.containsKey(id)) {
            return false;
        }
        UUID uid = new UUIDRetriever(id).getUUID();
        GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, id);
        UUIDRetriever.setSkin(gp);
        EntityPlayer newPlayer = new EntityPlayer(MinecraftServer.getServer(), (WorldServer)MinecraftServer.getServer().getWorld(), gp, new PlayerInteractManager(MinecraftServer.getServer().getWorld()));
        playertracker.put(id, newPlayer);
        displaynameholder.put(id, id);
        skinholder.put(id, id);
        return true;
    }

    public static EntityPlayer getPlayer(String id) {
        if (playertracker.containsKey(id)) {
            return playertracker.get(id);
        }
        return null;
    }

    public static String getDisName(String id) {
        if (displaynameholder.containsKey(id)) {
            return displaynameholder.get(id);
        }
        return null;
    }

    public static String getSkin(String id) {
        if (skinholder.containsKey(id)) {
            return skinholder.get(id);
        }
        return null;
    }

    public static void setDisplayName(String id, String value) {
        EntityPlayer p = FakePlayerTracker_R1.getPlayer(id);
        if (p != null) {
            UUID uid = new UUIDRetriever(FakePlayerTracker_R1.getSkin(id)).getUUID();
            GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, value);
            UUIDRetriever.setSkin(gp);
            EntityPlayer newPlayer = new EntityPlayer(MinecraftServer.getServer(), (WorldServer)MinecraftServer.getServer().getWorld(), gp, new PlayerInteractManager(MinecraftServer.getServer().getWorld()));
            newPlayer.setLocation(p.locX, p.locY, p.locZ, p.pitch, p.yaw);
            newPlayer.inventory = p.inventory;
            newPlayer.displayName = p.displayName;
            newPlayer.setHealth(p.getHealth());
            playertracker.remove(id);
            playertracker.put(id, newPlayer);
            displaynameholder.put(id, value);
        }
    }

    public static void setSkin(String id, String value) {
        EntityPlayer p = FakePlayerTracker_R1.getPlayer(id);
        if (p != null) {
            UUID uid = new UUIDRetriever(value).getUUID();
            GameProfile gp = new GameProfile(uid == null ? UUID.randomUUID() : uid, FakePlayerTracker_R1.getDisName(id));
            UUIDRetriever.setSkin(gp);
            EntityPlayer newPlayer = new EntityPlayer(MinecraftServer.getServer(), (WorldServer)MinecraftServer.getServer().getWorld(), gp, new PlayerInteractManager(MinecraftServer.getServer().getWorld()));
            newPlayer.setLocation(p.locX, p.locY, p.locZ, p.pitch, p.yaw);
            newPlayer.inventory = p.inventory;
            newPlayer.displayName = p.displayName;
            newPlayer.setHealth(p.getHealth());
            playertracker.remove(id);
            playertracker.put(id, newPlayer);
            skinholder.put(id, value);
        }
    }

    public static Boolean isSneaking(String id) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            return ep.isSneaking();
        }
        return false;
    }

    public static void sneak(String id, boolean sneak) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            ep.setSneaking(sneak);
            PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(ep.getId(), ep.getDataWatcher(), true);
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)meta);
            }
        }
    }

    public static void swingArm(String id) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            PacketPlayOutAnimation animation = new PacketPlayOutAnimation((Entity)ep, 0);
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)animation);
            }
        }
    }

    public static void setItemInHand(String id, int slot) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            PacketPlayOutHeldItemSlot held = new PacketPlayOutHeldItemSlot(slot);
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)held);
            }
        }
    }

    public static void move(String id, Location newloc) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            Location loc = new Location((World)ep.getWorld().getWorld(), ep.locX, ep.locY, ep.locX);
            FakePlayerTracker_R1.move(id, loc, newloc);
        }
    }

    public static void move(String id, Location old, Location newloc) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            PacketPlayOutRelEntityMoveLook moveLook = new PacketPlayOutRelEntityMoveLook(ep.getId(), (byte)((newloc.getBlockX() - old.getBlockX()) * 32), (byte)((newloc.getBlockY() - old.getBlockY()) * 32), (byte)((newloc.getBlockZ() - old.getBlockZ()) * 32), 0, 0, ep.getBukkitEntity().isOnGround());
            PacketPlayOutEntityLook look = new PacketPlayOutEntityLook(ep.getId(), (byte)(newloc.getYaw() * 256.0f / 360.0f), (byte)(newloc.getPitch() * 256.0f / 360.0f), ep.getBukkitEntity().isOnGround());
            PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation((Entity)ep, (byte)(newloc.getYaw() * 256.0f / 360.0f));
            ep.yaw = newloc.getYaw();
            ep.pitch = newloc.getPitch();
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)moveLook);
                aep.playerConnection.sendPacket((Packet)look);
                aep.playerConnection.sendPacket((Packet)rotation);
            }
        }
    }

    public static void teleport(String id, Location newloc) {
        EntityPlayer ep = FakePlayerTracker_R1.getPlayer(id);
        if (ep != null) {
            PacketPlayOutEntityTeleport teleport = new PacketPlayOutEntityTeleport(ep.getId(), (int)newloc.getX(), (int)newloc.getY(), (int)newloc.getZ(), (byte)newloc.getYaw(), (byte)newloc.getPitch(), ep.onGround);
            ep.yaw = newloc.getYaw();
            ep.pitch = newloc.getPitch();
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                EntityPlayer aep = ((CraftPlayer)p).getHandle();
                aep.playerConnection.sendPacket((Packet)teleport);
            }
        }
    }
}

