/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Attributes;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.NBTTagList;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import uk.co.umbaska.Enums.Operation;

public class Attributes_V1_8_R3 {
    public net.minecraft.server.v1_8_R3.ItemStack nmsStack;
    private NBTTagCompound parent;
    private NBTTagList attributes;

    public Attributes_V1_8_R3(ItemStack stack) {
        this.nmsStack = CraftItemStack.asNMSCopy((ItemStack)stack);
        this.parent = this.nmsStack.getTag() == null ? new NBTTagCompound() : this.nmsStack.getTag();
        if (this.parent.hasKey("AttributeModifiers")) {
            this.attributes = this.parent.getList("AttributeModifiers", 10);
        } else {
            this.attributes = new NBTTagList();
            this.parent.set("AttributeModifiers", (NBTBase)this.attributes);
        }
    }

    public ItemStack getStack() {
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R3.ItemStack)this.nmsStack);
    }

    public int size() {
        return this.attributes.size();
    }

    public void add(Attribute attribute) {
        this.attributes.add((NBTBase)attribute.data);
    }

    public boolean remove(Attribute attribute) {
        UUID uuid = attribute.getUUID();
        Iterator<Attribute> it = this.values().iterator();
        while (it.hasNext()) {
            if (!Objects.equal((Object)it.next().getUUID(), (Object)uuid)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        this.attributes = new NBTTagList();
        this.parent.set("AttributeModifiers", (NBTBase)this.attributes);
    }

    public Attribute get(int index) {
        return new Attribute(this.attributes.get(index));
    }

    public Iterable<Attribute> values() {
        final List list = this.getList();
        return new Iterable<Attribute>(){

            @Override
            public Iterator<Attribute> iterator() {
                return Iterators.transform(list.iterator(), (Function)new Function<NBTBase, Attribute>(){

                    public Attribute apply(@Nullable NBTBase data) {
                        return new Attribute((NBTTagCompound)data);
                    }
                });
            }
        };
    }

    private <T> List<T> getList() {
        try {
            Field listField = NBTTagList.class.getDeclaredField("list");
            listField.setAccessible(true);
            return (List)listField.get(this.attributes);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to access reflection.", e);
        }
    }

    public static class Attribute {
        private NBTTagCompound data;

        private Attribute(Builder builder) {
            this.data = new NBTTagCompound();
            this.setAmount(builder.amount);
            this.setOperation(builder.operation);
            this.setAttributeType(builder.type);
            this.setName(builder.name);
            this.setUUID(builder.uuid);
        }

        private Attribute(NBTTagCompound data) {
            this.data = data;
        }

        public double getAmount() {
            return this.data.getDouble("Amount");
        }

        public void setAmount(double amount) {
            this.data.setDouble("Amount", amount);
        }

        public Operation getOperation() {
            return Operation.fromId(this.data.getInt("Operation"));
        }

        public void setOperation(@Nonnull Operation operation) {
            Preconditions.checkNotNull((Object)((Object)operation), (Object)"operation cannot be NULL.");
            this.data.setInt("Operation", operation.getId());
        }

        public AttributeType getAttributeType() {
            return AttributeType.fromId(this.data.getString("AttributeName"));
        }

        public void setAttributeType(@Nonnull AttributeType type) {
            Preconditions.checkNotNull((Object)type, (Object)"type cannot be NULL.");
            this.data.setString("AttributeName", type.getMinecraftId());
        }

        public String getName() {
            return this.data.getString("Name");
        }

        public void setName(@Nonnull String name) {
            this.data.setString("Name", name);
        }

        public UUID getUUID() {
            return new UUID(this.data.getLong("UUIDMost"), this.data.getLong("UUIDLeast"));
        }

        public void setUUID(@Nonnull UUID id) {
            Preconditions.checkNotNull((Object)"id", (Object)"id cannot be NULL.");
            this.data.setLong("UUIDLeast", id.getLeastSignificantBits());
            this.data.setLong("UUIDMost", id.getMostSignificantBits());
        }

        public static Builder newBuilder() {
            return new Builder().uuid(UUID.randomUUID()).operation(Operation.ADD_NUMBER);
        }

        public static class Builder {
            private double amount;
            private Operation operation = Operation.ADD_NUMBER;
            private AttributeType type;
            private String name;
            private UUID uuid;

            private Builder() {
            }

            public Builder amount(double amount) {
                this.amount = amount;
                return this;
            }

            public Builder operation(Operation operation) {
                this.operation = operation;
                return this;
            }

            public Builder type(AttributeType type) {
                this.type = type;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder uuid(UUID uuid) {
                this.uuid = uuid;
                return this;
            }

            public Attribute build() {
                return new Attribute(this);
            }
        }
    }

    public static class AttributeType {
        private static ConcurrentMap<String, AttributeType> LOOKUP = Maps.newConcurrentMap();
        public static final AttributeType GENERIC_MAX_HEALTH = new AttributeType("generic.maxHealth").register();
        public static final AttributeType GENERIC_FOLLOW_RANGE = new AttributeType("generic.followRange").register();
        public static final AttributeType GENERIC_ATTACK_DAMAGE = new AttributeType("generic.attackDamage").register();
        public static final AttributeType GENERIC_MOVEMENT_SPEED = new AttributeType("generic.movementSpeed").register();
        public static final AttributeType GENERIC_KNOCKBACK_RESISTANCE = new AttributeType("generic.knockbackResistance").register();
        private final String minecraftId;

        public AttributeType(String minecraftId) {
            this.minecraftId = minecraftId;
        }

        public String getMinecraftId() {
            return this.minecraftId;
        }

        public AttributeType register() {
            AttributeType old = LOOKUP.putIfAbsent(this.minecraftId, this);
            return old != null ? old : this;
        }

        public static AttributeType fromId(String minecraftId) {
            return (AttributeType)LOOKUP.get(minecraftId);
        }

        public static Iterable<AttributeType> values() {
            return LOOKUP.values();
        }
    }
}

