/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.JSON;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.server.v1_9_R1.IChatBaseComponent;
import net.minecraft.server.v1_9_R1.Packet;
import net.minecraft.server.v1_9_R1.PacketPlayOutChat;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class JsonBuilder {
    private List<String> extras = new ArrayList<String>();

    public JsonBuilder(String ... text) {
        for (String extra : text) {
            this.parse(extra);
        }
    }

    public JsonBuilder parse(String text) {
        String regex = "[&\u00a7]{1}([a-fA-Fl-oL-O0-9]){1}";
        text = text.replaceAll(regex, "\u00a7$1");
        if (!Pattern.compile(regex).matcher(text).find()) {
            this.withText(text);
            return this;
        }
        String[] words = text.split(regex);
        int index = words[0].length();
        for (String word : words) {
            try {
                if (index != words[0].length()) {
                    this.withText(word).withColor("\u00a7" + text.charAt(index - 1));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            index += word.length() + 2;
        }
        return this;
    }

    public JsonBuilder withText(String text) {
        this.extras.add("{text:\"" + text + "\"}");
        return this;
    }

    public JsonBuilder withColor(ChatColor color) {
        String c = color.name().toLowerCase();
        this.addSegment(color.isColor() ? "color:" + c : c + ":true");
        return this;
    }

    public JsonBuilder withColor(String color) {
        while (color.length() != 1) {
            color = color.substring(1).trim();
        }
        this.withColor(ChatColor.getByChar((String)color));
        return this;
    }

    public JsonBuilder withClickEvent(ClickAction action, String value) {
        this.addSegment("clickEvent:{action:" + action.toString().toLowerCase() + ",value:\"" + value + "\"}");
        return this;
    }

    public JsonBuilder withHoverEvent(HoverAction action, String value) {
        this.addSegment("hoverEvent:{action:" + action.toString().toLowerCase() + ",value:\"" + value + "\"}");
        return this;
    }

    private void addSegment(String segment) {
        String lastText = this.extras.get(this.extras.size() - 1);
        lastText = lastText.substring(0, lastText.length() - 1) + "," + segment + "}";
        this.extras.remove(this.extras.size() - 1);
        this.extras.add(lastText);
    }

    public String toString() {
        if (this.extras.size() <= 1) {
            return this.extras.size() == 0 ? "{text:\"\"}" : this.extras.get(0);
        }
        String text = this.extras.get(0).substring(0, this.extras.get(0).length() - 1) + ",extra:[";
        this.extras.remove(0);
        for (String extra : this.extras) {
            text = text + extra + ",";
        }
        text = text.substring(0, text.length() - 1) + "]}";
        return text;
    }

    public void sendJson(Player p) {
        ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat(IChatBaseComponent.ChatSerializer.a((String)this.toString())));
    }

    public static enum HoverAction {
        SHOW_TEXT;

    }

    public static enum ClickAction {
        RUN_COMMAND,
        SUGGEST_COMMAND,
        OPEN_URL;

    }
}

