/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.hologramBased;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import uk.co.umbaska.hologramBased.HologramCentral;

public class Hologram {
    private PacketContainer destroyPacket1_7;
    private PacketContainer destroyPacket1_8;
    private PacketContainer[] displayPackets1_7;
    private PacketContainer[] displayPackets1_8;
    private ArrayList<Map.Entry<Integer, Integer>> entityIds = new ArrayList();
    protected Location entityLastLocation;
    private ArrayList<String> hologramPlayers = new ArrayList();
    private HologramTarget hologramTarget = HologramTarget.BLACKLIST;
    private boolean isUsingWitherSkull = HologramCentral.isUsingWitherSkulls();
    private boolean keepAliveAfterEntityDies;
    private Location lastMovement = new Location(null, 0.0, 0.0, 0.0);
    private String[] lines;
    private double lineSpacing = 1.0;
    private Location location;
    private Vector moveVector;
    private boolean pitchControlsMoreThanY;
    private Entity relativeEntity;
    private Location relativeToEntity;
    private boolean setRelativePitch;
    private boolean setRelativeYaw;
    private int viewDistance = 100;
    private List<Entity> holoItems = new ArrayList<Entity>();

    private static int getId() {
        try {
            Field field = Class.forName("net.minecraft.server." + Bukkit.getServer().getClass().getName().split("\\.")[3] + ".Entity").getDeclaredField("entityCount");
            field.setAccessible(true);
            int id = field.getInt(null);
            field.set(null, id + 1);
            return id;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public Hologram(Location location, String ... lines) {
        assert (lines.length != 0) : "You need more lines than nothing!";
        assert (location.getWorld() != null) : "You can't have a null world in the location!";
        this.lines = lines;
        this.location = location.clone().add(0.0, 54.6, 0.0);
    }

    public Hologram addPlayer(Player ... players) {
        for (Player player : players) {
            if (this.hologramPlayers.contains(player.getName())) continue;
            this.hologramPlayers.add(player.getName());
            if (!this.isInUse()) continue;
            HologramCentral.addHologram(player, this);
        }
        return this;
    }

    protected PacketContainer getDestroyPacket(Player player) {
        if (HologramCentral.is1_8(player)) {
            return this.destroyPacket1_8;
        }
        return this.destroyPacket1_7;
    }

    public Entity getEntityFollowed() {
        return this.relativeEntity;
    }

    protected ArrayList<Map.Entry<Integer, Integer>> getEntityIds() {
        return this.entityIds;
    }

    public String[] getLines() {
        return this.lines;
    }

    public double getLineSpacing() {
        return this.lineSpacing;
    }

    public Location getLocation() {
        return this.location.clone().subtract(0.0, 54.6, 0.0);
    }

    public Vector getMovement() {
        return this.moveVector;
    }

    private ArrayList<Player> getPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.isVisible(player, player.getLocation())) continue;
            players.add(player);
        }
        return players;
    }

    public Location getRelativeToEntity() {
        return this.relativeToEntity;
    }

    protected PacketContainer[] getSpawnPackets(Player player) {
        if (HologramCentral.is1_8(player)) {
            return this.displayPackets1_8;
        }
        return this.displayPackets1_7;
    }

    public HologramTarget getTarget() {
        return this.hologramTarget;
    }

    public boolean hasPlayer(Player player) {
        return this.hologramPlayers.contains(player.getName());
    }

    public boolean isInUse() {
        return HologramCentral.isInUse(this);
    }

    public boolean isRelativePitch() {
        return this.setRelativePitch;
    }

    public boolean isRelativePitchControlMoreThanHeight() {
        return this.pitchControlsMoreThanY;
    }

    public boolean isRelativeYaw() {
        return this.setRelativeYaw;
    }

    public boolean isRemovedOnEntityDeath() {
        return this.keepAliveAfterEntityDies;
    }

    public boolean isUsingArmorStand() {
        return !this.isUsingWitherSkull;
    }

    public boolean isUsingWitherSkull() {
        return this.isUsingWitherSkull;
    }

    boolean isVisible(Player player, Location loc) {
        return this.getTarget() == HologramTarget.BLACKLIST != this.hasPlayer(player) && loc.getWorld() == this.getLocation().getWorld() && loc.distance(this.getLocation()) <= (double)this.viewDistance;
    }

    private void makeDestroyPacket() {
        int[] ids = new int[this.entityIds.size() * 2];
        int[] ids2 = new int[ids.length / 2];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : this.entityIds) {
            ids2[i / 2] = entry.getKey();
            ids[i++] = entry.getKey();
            ids[i++] = entry.getValue();
        }
        this.destroyPacket1_7 = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        this.destroyPacket1_7.getIntegerArrays().write(0, (Object)ids);
        this.destroyPacket1_8 = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        this.destroyPacket1_8.getIntegerArrays().write(0, (Object)ids2);
    }

    private void makeDisplayPackets() {
        Iterator<Map.Entry<Integer, Integer>> itel = this.entityIds.iterator();
        this.displayPackets1_7 = new PacketContainer[this.lines.length * 3];
        this.displayPackets1_8 = new PacketContainer[this.lines.length * (this.isUsingWitherSkull() ? 2 : 1)];
        int b = 0;
        while (itel.hasNext()) {
            int a;
            Map.Entry<Integer, Integer> entry = itel.next();
            PacketContainer[] packets = this.makeSpawnPacket1_8(b, entry.getKey(), this.lines[this.lines.length - 1 - b]);
            for (a = 0; a < (this.isUsingWitherSkull() ? 2 : 1); ++a) {
                this.displayPackets1_8[b + a] = packets[a];
            }
            packets = this.makeSpawnPackets1_7(b, entry.getKey(), entry.getValue(), this.lines[this.lines.length - 1 - b]);
            for (a = 0; a < 3; ++a) {
                this.displayPackets1_7[b * 3 + a] = packets[a];
            }
            ++b;
        }
    }

    private PacketContainer[] makeSpawnPacket1_8(int height, int witherId, String horseName) {
        if (this.isUsingWitherSkull()) {
            PacketContainer[] packets = new PacketContainer[2];
            packets[0] = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
            StructureModifier ints = packets[0].getIntegers();
            ints.write(0, (Object)witherId);
            ints.write(1, (Object)((int)(this.getLocation().getX() * 32.0)));
            ints.write(2, (Object)((int)((this.location.getY() + -55.15 + (double)height * (this.getLineSpacing() * 0.285)) * 32.0)));
            ints.write(3, (Object)((int)(this.getLocation().getZ() * 32.0)));
            ints.write(9, (Object)66);
            packets[1] = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            packets[1].getIntegers().write(0, (Object)witherId);
            ArrayList<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
            list.add(new WrappedWatchableObject(0, (Object)0));
            list.add(new WrappedWatchableObject(2, (Object)horseName));
            list.add(new WrappedWatchableObject(3, (Object)1));
            packets[1].getWatchableCollectionModifier().write(0, list);
            return packets;
        }
        PacketContainer displayPacket = null;
        displayPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
        StructureModifier ints = displayPacket.getIntegers();
        ints.write(0, (Object)witherId);
        ints.write(1, (Object)30);
        ints.write(2, (Object)((int)(this.getLocation().getX() * 32.0)));
        ints.write(3, (Object)((int)((this.location.getY() + -56.7 + (double)height * (this.getLineSpacing() * 0.285)) * 32.0)));
        ints.write(4, (Object)((int)(this.getLocation().getZ() * 32.0)));
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setObject(0, (Object)32);
        watcher.setObject(2, (Object)horseName);
        watcher.setObject(3, (Object)1);
        displayPacket.getDataWatcherModifier().write(0, (Object)watcher);
        return new PacketContainer[]{displayPacket};
    }

    private PacketContainer[] makeSpawnPackets1_7(int height, int witherId, int horseId, String horseName) {
        PacketContainer[] displayPackets = new PacketContainer[3];
        displayPackets[0] = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        StructureModifier ints = displayPackets[0].getIntegers();
        ints.write(0, (Object)witherId);
        ints.write(1, (Object)((int)(this.getLocation().getX() * 32.0)));
        ints.write(2, (Object)((int)((this.location.getY() + (double)height * (this.getLineSpacing() * 0.285)) * 32.0)));
        ints.write(3, (Object)((int)(this.getLocation().getZ() * 32.0)));
        ints.write(9, (Object)66);
        displayPackets[1] = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
        ints = displayPackets[1].getIntegers();
        ints.write(0, (Object)horseId);
        ints.write(1, (Object)100);
        ints.write(2, (Object)((int)(this.getLocation().getX() * 32.0)));
        ints.write(3, (Object)((int)((this.location.getY() + (double)height * (this.getLineSpacing() * 0.285) + 0.23) * 32.0)));
        ints.write(4, (Object)((int)(this.getLocation().getZ() * 32.0)));
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setObject(0, (Object)0);
        watcher.setObject(1, (Object)300);
        watcher.setObject(10, (Object)horseName);
        watcher.setObject(11, (Object)1);
        watcher.setObject(12, (Object)-1700000);
        displayPackets[1].getDataWatcherModifier().write(0, (Object)watcher);
        displayPackets[2] = new PacketContainer(PacketType.Play.Server.ATTACH_ENTITY);
        ints = displayPackets[2].getIntegers();
        ints.write(1, (Object)horseId);
        ints.write(2, (Object)witherId);
        return displayPackets;
    }

    public Hologram moveHologram(Location location) {
        this.moveHologram(location, true);
        return this;
    }

    public Hologram moveHologram(Location newLocation, boolean setNewRelativeLocation) {
        ArrayList<Player> oldPlayers = this.getPlayers();
        Location loc = this.getLocation();
        this.location = newLocation.clone().add(0.0, 54.6, 0.0);
        if (setNewRelativeLocation && this.getEntityFollowed() != null) {
            this.relativeToEntity = this.getLocation().subtract(this.getEntityFollowed().getLocation());
        }
        if (this.isInUse()) {
            this.makeDisplayPackets();
            ArrayList<Player> newPlayers = this.getPlayers();
            Iterator<Player> itel = oldPlayers.iterator();
            while (itel.hasNext()) {
                Player p = itel.next();
                if (newPlayers.contains(p)) continue;
                itel.remove();
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(p, this.getDestroyPacket(p), false);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            PacketContainer[] packets1_7 = null;
            PacketContainer[] packets1_8 = null;
            if (!oldPlayers.isEmpty()) {
                this.lastMovement.add(this.location.getX() - loc.getX(), this.location.getY() - loc.getY(), this.location.getZ() - loc.getZ());
                int x = (int)Math.floor(32.0 * this.lastMovement.getX());
                int y = (int)Math.floor(32.0 * this.lastMovement.getY());
                int z = (int)Math.floor(32.0 * this.lastMovement.getZ());
                packets1_7 = new PacketContainer[this.lines.length];
                packets1_8 = new PacketContainer[this.lines.length];
                int i = 0;
                if (x >= -128 && x < 128 && y >= -128 && y < 128 && z >= -128 && z < 128) {
                    this.lastMovement.subtract((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                    for (Map.Entry<Integer, Integer> entityId : this.entityIds) {
                        packets1_7[i] = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
                        packets1_7[i].getIntegers().write(0, (Object)entityId.getKey());
                        StructureModifier bytes = packets1_7[i].getBytes();
                        bytes.write(0, (Object)((byte)x));
                        bytes.write(1, (Object)((byte)y));
                        bytes.write(2, (Object)((byte)z));
                        packets1_8[i] = packets1_7[i];
                        ++i;
                    }
                } else {
                    x = (int)Math.floor(32.0 * this.location.getX());
                    z = (int)Math.floor(32.0 * this.location.getZ());
                    this.lastMovement = new Location(null, this.location.getX() - (double)x / 32.0, 0.0, this.location.getZ() - (double)z / 32.0);
                    for (Map.Entry<Integer, Integer> entityId : this.entityIds) {
                        packets1_7[i] = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
                        StructureModifier ints = packets1_7[i].getIntegers();
                        ints.write(0, (Object)entityId.getKey());
                        ints.write(1, (Object)x);
                        ints.write(2, (Object)((int)Math.floor((this.location.getY() + (double)i * (this.getLineSpacing() * 0.285)) * 32.0)));
                        ints.write(3, (Object)z);
                        packets1_8[i] = packets1_7[i].shallowClone();
                        packets1_8[i].getIntegers().write(2, (Object)((int)Math.floor((this.location.getY() + -55.15 + (double)i * (this.getLineSpacing() * 0.285)) * 32.0)));
                        ++i;
                    }
                }
            }
            for (Player p : newPlayers) {
                try {
                    for (PacketContainer packet : oldPlayers.contains(p) ? (HologramCentral.is1_8(p) ? packets1_8 : packets1_7) : this.getSpawnPackets(p)) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(p, packet, false);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    public Hologram remove() {
        HologramCentral.removeHologram(this);
        return this;
    }

    public Hologram removePlayer(Player ... players) {
        for (Player player : players) {
            if (!this.hologramPlayers.contains(player.getName())) continue;
            this.hologramPlayers.remove(player.getName());
            if (!this.isInUse()) continue;
            HologramCentral.removeHologram(player, this);
        }
        return this;
    }

    public Hologram setFollowEntity(Entity entity) {
        this.setFollowEntity(entity, true);
        return this;
    }

    public Hologram setFollowEntity(Entity entity, boolean isRemoveOnEntityDeath) {
        this.setFollowEntity(entity, isRemoveOnEntityDeath, false, false, false);
        return this;
    }

    public Hologram setFollowEntity(Entity entity, boolean isRemoveOnEntityDeath, boolean setRelativeYaw, boolean setRelativePitch, boolean pitchControlsMoreThanY) {
        this.relativeEntity = entity;
        if (entity != null) {
            this.keepAliveAfterEntityDies = isRemoveOnEntityDeath;
            this.relativeToEntity = this.getLocation().subtract(entity.getLocation());
            this.entityLastLocation = entity.getLocation();
            Location l = entity.getLocation();
            if (setRelativeYaw || setRelativePitch) {
                this.relativeToEntity.setPitch(l.getPitch());
                this.relativeToEntity.setYaw(l.getYaw());
                this.setRelativePitch = setRelativePitch;
                this.setRelativeYaw = setRelativeYaw;
                this.pitchControlsMoreThanY = pitchControlsMoreThanY;
            }
        }
        return this;
    }

    public Hologram setLines(String ... lines) {
        block25: {
            if (this.lines.equals(lines)) break block25;
            Object[] oldLines = (String[])this.lines.clone();
            this.lines = lines;
            lines = (String[])lines.clone();
            ArrayUtils.reverse((Object[])lines);
            ArrayUtils.reverse((Object[])oldLines);
            if (this.isInUse()) {
                Map.Entry<Integer, Integer> entry;
                int i;
                ArrayList<Player> players = this.getPlayers();
                for (i = 0; i < Math.min(this.entityIds.size(), lines.length); ++i) {
                    if (oldLines.length > i && ((String)oldLines[i]).equals(lines[i])) continue;
                    entry = this.entityIds.get(i);
                    PacketContainer packet1_7 = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                    packet1_7.getIntegers().write(0, (Object)entry.getValue());
                    ArrayList<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
                    list.add(new WrappedWatchableObject(0, (Object)0));
                    list.add(new WrappedWatchableObject(1, (Object)300));
                    list.add(new WrappedWatchableObject(10, (Object)lines[i]));
                    list.add(new WrappedWatchableObject(11, (Object)1));
                    list.add(new WrappedWatchableObject(12, (Object)-1700000));
                    packet1_7.getWatchableCollectionModifier().write(0, list);
                    PacketContainer packet1_8 = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
                    packet1_8.getIntegers().write(0, (Object)entry.getKey());
                    list = new ArrayList();
                    list.add(new WrappedWatchableObject(0, (Object)32));
                    list.add(new WrappedWatchableObject(2, (Object)lines[i]));
                    list.add(new WrappedWatchableObject(3, (Object)1));
                    packet1_8.getWatchableCollectionModifier().write(0, list);
                    for (Player p : players) {
                        try {
                            ProtocolLibrary.getProtocolManager().sendServerPacket(p, HologramCentral.is1_8(p) ? packet1_8 : packet1_7, false);
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (lines.length != this.entityIds.size()) {
                    if (lines.length < this.entityIds.size()) {
                        int[] destroyIds = new int[(this.entityIds.size() - lines.length) * 2];
                        int e = 0;
                        while (this.entityIds.size() > lines.length) {
                            Map.Entry<Integer, Integer> entry2 = this.entityIds.remove(this.entityIds.size() - 1);
                            destroyIds[e++] = entry2.getKey();
                            destroyIds[e++] = entry2.getValue();
                        }
                        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
                        destroyPacket.getIntegerArrays().write(0, (Object)destroyIds);
                        for (Player p : players) {
                            try {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(p, destroyPacket, false);
                            }
                            catch (InvocationTargetException b) {
                                b.printStackTrace();
                            }
                        }
                    } else if (lines.length > this.entityIds.size()) {
                        while (i < lines.length) {
                            entry = new AbstractMap.SimpleEntry<Integer, Integer>(Hologram.getId(), Hologram.getId());
                            this.entityIds.add(entry);
                            PacketContainer[] packets1_7 = this.makeSpawnPackets1_7(i, entry.getKey(), entry.getValue(), lines[i]);
                            PacketContainer[] packet1_8 = this.makeSpawnPacket1_8(i, entry.getKey(), lines[i]);
                            for (Player p : players) {
                                try {
                                    if (HologramCentral.is1_8(p)) {
                                        for (PacketContainer packet : packet1_8) {
                                            ProtocolLibrary.getProtocolManager().sendServerPacket(p, packet, false);
                                        }
                                        continue;
                                    }
                                    for (PacketContainer packet : packets1_7) {
                                        ProtocolLibrary.getProtocolManager().sendServerPacket(p, packet, false);
                                    }
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                            ++i;
                        }
                    }
                    this.makeDestroyPacket();
                }
                this.makeDisplayPackets();
            } else if (lines.length < this.entityIds.size()) {
                while (this.entityIds.size() > lines.length) {
                    this.entityIds.remove(this.entityIds.size() - 1);
                }
            } else {
                for (int i = this.entityIds.size(); i < lines.length; ++i) {
                    AbstractMap.SimpleEntry<Integer, Integer> entry = new AbstractMap.SimpleEntry<Integer, Integer>(Hologram.getId(), Hologram.getId());
                    this.entityIds.add(entry);
                }
            }
        }
        return this;
    }

    public Hologram setLineSpacing(double newLineSpacing) {
        this.lineSpacing = newLineSpacing;
        if (this.isInUse()) {
            this.makeDisplayPackets();
            HologramCentral.removeHologram(this);
            HologramCentral.addHologram(this);
        }
        return this;
    }

    public Hologram setMovement(Vector vector) {
        this.moveVector = vector;
        return this;
    }

    public Hologram setRadius(int viewDistance) {
        assert (viewDistance > 0) : "Why the hell are you setting the view distance to " + viewDistance + "?!?!";
        this.viewDistance = viewDistance;
        if (this.isInUse()) {
            HologramCentral.removeHologram(this);
            HologramCentral.addHologram(this);
        }
        return this;
    }

    public Hologram setRelativeToEntity(Location location) {
        this.relativeToEntity = location;
        return this;
    }

    public Hologram setTarget(HologramTarget target) {
        if (target != this.getTarget()) {
            this.hologramTarget = target;
            if (this.isInUse()) {
                HologramCentral.removeHologram(this);
                HologramCentral.addHologram(this);
            }
        }
        return this;
    }

    public Hologram setUsingArmorStand() {
        this.isUsingWitherSkull = true;
        this.makeDisplayPackets();
        return this;
    }

    public Hologram setUsingWitherSkull() {
        this.isUsingWitherSkull = false;
        this.makeDisplayPackets();
        return this;
    }

    public Hologram start() {
        if (!this.isInUse()) {
            for (int i = this.entityIds.size(); i < this.lines.length; ++i) {
                int entityId = Hologram.getId();
                this.entityIds.add(new AbstractMap.SimpleEntry<Integer, Integer>(Hologram.getId(), entityId));
            }
            this.makeDestroyPacket();
            this.makeDisplayPackets();
            HologramCentral.addHologram(this);
        }
        return this;
    }

    public Hologram stop() {
        return this.remove();
    }

    public static enum HologramTarget {
        BLACKLIST,
        WHITELIST;

    }
}

