/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils.Disguise;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import uk.co.umbaska.Utils.Disguise.EntityDisguise;
import uk.co.umbaska.Utils.ReflectionUtils;

public class MyDisguise {
    private static final String bukkitversion = Bukkit.getServer().getClass().getPackage().getName().substring(23);
    private String customName;
    private EntityDisguise type;
    private Entity disguised;
    private ItemStack hand;
    private ItemStack helm;
    private ItemStack chst;
    private ItemStack leg;
    private ItemStack boot;

    public MyDisguise(Entity p, EntityDisguise type) {
        this(p, type, null);
    }

    public MyDisguise(Entity p, EntityDisguise type, String name) {
        this(p, type, name, null, null, null, null, null);
    }

    public MyDisguise(Entity p, EntityDisguise type, String name, ItemStack inhand, ItemStack helmet, ItemStack chestplate, ItemStack leggings, ItemStack boots) {
        this.customName = name;
        this.type = type;
        this.disguised = p;
        this.hand = inhand;
        this.helm = helmet;
        this.chst = chestplate;
        this.leg = leggings;
        this.boot = boots;
    }

    public void sendDisguise(Player to) throws Exception {
        if (to.equals(this.disguised)) {
            throw new IllegalArgumentException("Target Player cannot be the same as the disguised player");
        }
        Object packetplayoutentitydestroy = ReflectionUtils.instantiateObject("PacketPlayOutEntityDestroy", ReflectionUtils.PackageType.MINECRAFT_SERVER, new Object[]{new int[]{this.disguised.getEntityId()}});
        Object world = ReflectionUtils.invokeMethod((Object)this.disguised.getWorld(), "getHandle", null);
        Class<?> entity = Class.forName(this.type.getClassName());
        Object ent = ReflectionUtils.instantiateObject(entity, world);
        ReflectionUtils.invokeMethod(ent, "setPosition", this.disguised.getLocation().getX(), this.disguised.getLocation().getY(), this.disguised.getLocation().getZ());
        ReflectionUtils.getMethod(entity, "d", Integer.TYPE).invoke(ent, this.disguised.getEntityId());
        if (this.customName != null) {
            ReflectionUtils.getMethod(entity, "setCustomName", String.class).invoke(ent, this.customName);
            ReflectionUtils.getMethod(entity, "setCustomNameVisible", Boolean.TYPE).invoke(ent, true);
        }
        this.handleSpecialTypes(this.type, ent);
        Object packetplayoutspawnentityliving = ReflectionUtils.instantiateObject("PacketPlayOutSpawnEntityLiving", ReflectionUtils.PackageType.MINECRAFT_SERVER, ent);
        this.sendPacket(to, packetplayoutentitydestroy);
        this.sendPacket(to, packetplayoutspawnentityliving);
        if (this.hand != null) {
            this.sendArmorContentPackets(to, this.disguised.getEntityId(), 0, this.hand);
        }
        if (this.helm != null) {
            this.sendArmorContentPackets(to, this.disguised.getEntityId(), 1, this.helm);
        }
        if (this.chst != null) {
            this.sendArmorContentPackets(to, this.disguised.getEntityId(), 2, this.chst);
        }
        if (this.leg != null) {
            this.sendArmorContentPackets(to, this.disguised.getEntityId(), 3, this.leg);
        }
        if (this.boot != null) {
            this.sendArmorContentPackets(to, this.disguised.getEntityId(), 4, this.boot);
        }
    }

    private void sendDisguise(Player ... players) {
        for (Player P : players) {
            if (P.equals(this.disguised)) continue;
            try {
                this.sendDisguise(P);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateDisguise(Player forwho) throws Exception {
        this.sendDisguise(forwho);
    }

    public void updateDisguise(Player ... players) {
        this.sendDisguise(players);
    }

    public void removeDisguise() throws ReflectiveOperationException {
        Object ppoed = ReflectionUtils.instantiateObject("PacketPlayOutEntityDestroy", ReflectionUtils.PackageType.MINECRAFT_SERVER, new Object[]{new int[]{this.disguised.getEntityId()}});
        Object ppones = ReflectionUtils.instantiateObject("PacketPlayOutNamedEntitySpawn", ReflectionUtils.PackageType.MINECRAFT_SERVER, ReflectionUtils.invokeMethod((Object)this.disguised, "getHandle", null));
        ItemStack hand = null;
        ItemStack helm = null;
        ItemStack chst = null;
        ItemStack leg = null;
        ItemStack boot = null;
        hand = ((LivingEntity)this.disguised).getEquipment().getItemInHand();
        helm = ((LivingEntity)this.disguised).getEquipment().getHelmet();
        chst = ((LivingEntity)this.disguised).getEquipment().getChestplate();
        leg = ((LivingEntity)this.disguised).getEquipment().getLeggings();
        boot = ((LivingEntity)this.disguised).getEquipment().getBoots();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.equals(this.disguised)) continue;
            try {
                this.sendPacket(p, ppoed);
                this.sendPacket(p, ppones);
                if (hand != null) {
                    this.sendArmorContentPackets(p, this.disguised.getEntityId(), 0, hand);
                }
                if (helm != null) {
                    this.sendArmorContentPackets(p, this.disguised.getEntityId(), 1, helm);
                }
                if (chst != null) {
                    this.sendArmorContentPackets(p, this.disguised.getEntityId(), 2, chst);
                }
                if (leg != null) {
                    this.sendArmorContentPackets(p, this.disguised.getEntityId(), 3, leg);
                }
                if (boot == null) continue;
                this.sendArmorContentPackets(p, this.disguised.getEntityId(), 4, boot);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void changePlayerDisguise(EntityDisguise type, Player sendto) throws Exception {
        this.type = type;
        this.sendDisguise(sendto);
    }

    public void changePlayerDisguise(EntityDisguise type, Player ... sendto) throws Exception {
        this.type = type;
        this.sendDisguise(sendto);
    }

    private void sendPacket(Player p, Object pack) throws Exception {
        Class<?> packet = Class.forName("net.minecraft.server." + bukkitversion + ".Packet");
        Class<?> craftPlayer = Class.forName("org.bukkit.craftbukkit." + bukkitversion + ".entity.CraftPlayer");
        Object handle = craftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
        Object con = handle.getClass().getField("playerConnection").get(handle);
        con.getClass().getMethod("sendPacket", packet).invoke(con, pack);
    }

    private void sendArmorContentPackets(Player to, int entityID, int slot, ItemStack item) throws Exception {
        ReflectionUtils.PackageType type = bukkitversion.startsWith("v1_7_") ? ReflectionUtils.PackageType.CRAFTBUKKIT : ReflectionUtils.PackageType.CRAFTBUKKIT_INVENTORY;
        Object craftitmstk = ReflectionUtils.getMethod("CraftItemStack", type, "asNMSCopy", item.getClass()).invoke(null, item);
        Object metadarapacket = ReflectionUtils.instantiateObject("PacketPlayOutEntityEquipment", ReflectionUtils.PackageType.MINECRAFT_SERVER, entityID, slot, craftitmstk);
        this.sendPacket(to, metadarapacket);
    }

    private Object handleSpecialTypes(EntityDisguise type, Object entity) throws Exception {
        switch (type) {
            case WITHER_SKELETON: {
                ReflectionUtils.invokeMethod(entity, "setSkeletonType", 1);
            }
        }
        return entity;
    }

    public ItemStack getItemInHand() {
        return this.hand;
    }

    public void setItemInHand(ItemStack hand) {
        this.hand = hand;
    }

    public ItemStack getHelmet() {
        return this.helm;
    }

    public void setHelmet(ItemStack helm) {
        this.helm = helm;
    }

    public ItemStack getChestplate() {
        return this.chst;
    }

    public void setChestplate(ItemStack chst) {
        this.chst = chst;
    }

    public ItemStack getLeggings() {
        return this.leg;
    }

    public void setLeggings(ItemStack leg) {
        this.leg = leg;
    }

    public ItemStack getBoots() {
        return this.boot;
    }

    public void setBoots(ItemStack boot) {
        this.boot = boot;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public EntityDisguise getType() {
        return this.type;
    }

    public void setType(EntityDisguise type) {
        this.type = type;
    }

    public Entity getDisguised() {
        return this.disguised;
    }
}

