/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.GattSk.Extras;

import ch.njol.skript.Skript;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import uk.co.umbaska.Main;

public class WorldManagers {
    public static String error;
    public static World lastCreatedWorld;
    public static String[] worldList;

    public static void createWorld(String name) {
        if (!WorldManagers.worldExists(name)) {
            World world = Bukkit.createWorld((WorldCreator)new WorldCreator(name));
            lastCreatedWorld = Bukkit.getWorld((String)world.getName());
        } else {
            error = "World already exists";
            WorldManagers.worldError();
        }
    }

    public static void createWorldUsingGenerator(String name, String generatorName) {
        if (!WorldManagers.worldExists(name)) {
            WorldCreator c = new WorldCreator(name);
            c.generator(WorldManagers.getGenerator(generatorName, name));
            World world = c.createWorld();
            lastCreatedWorld = Bukkit.getWorld((String)world.getName());
        } else {
            error = "World already exists";
            WorldManagers.worldError();
        }
    }

    static ChunkGenerator getGenerator(String generator, String name) {
        if (generator == null) {
            return null;
        }
        Plugin generatorPlugin = Bukkit.getPluginManager().getPlugin(generator);
        if (generatorPlugin == null) {
            return null;
        }
        return generatorPlugin.getDefaultWorldGenerator(name, null);
    }

    public static void createWorldFrom(String name, String folderName) {
        if (!WorldManagers.worldExists(name)) {
            File srcFolder = new File(folderName);
            File destFolder = new File(name);
            if (!srcFolder.exists()) {
                error = "Folder to clone doesn't exist!";
                WorldManagers.worldError();
                return;
            }
            try {
                FileUtils.deleteDirectory((File)destFolder);
                FileUtils.copyDirectory((File)srcFolder, (File)destFolder);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(0);
            }
            final String worldname = name;
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, new Runnable(){

                @Override
                public void run() {
                    World world = Bukkit.createWorld((WorldCreator)new WorldCreator(worldname));
                    lastCreatedWorld = Bukkit.getWorld((String)world.getName());
                }
            }, 60L);
        } else {
            error = "World already exists";
            WorldManagers.worldError();
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
                System.out.println("Directory copied from " + src + "  to " + dest);
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                WorldManagers.copyFolder(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied from " + src + " to " + dest);
        }
    }

    public static void deleteWorld(String name) {
        if (WorldManagers.worldExists(name)) {
            Bukkit.unloadWorld((String)name, (boolean)false);
            final String delfile = name.replaceAll("/", Matcher.quoteReplacement(File.separator));
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, new Runnable(){

                @Override
                public void run() {
                    File file = new File(delfile);
                    file.delete();
                }
            }, 20L);
        } else {
            error = "World doesn't exist";
            WorldManagers.worldError();
        }
    }

    public static void unloadWorld(String name) {
        if (WorldManagers.worldExists(name)) {
            Bukkit.unloadWorld((String)name, (boolean)true);
        } else {
            error = "World doesn't exist";
            WorldManagers.worldError();
        }
    }

    public static void loadWorld(String name) {
        if (!WorldManagers.worldExists(name)) {
            Bukkit.createWorld((WorldCreator)new WorldCreator(name));
        } else {
            error = "World already exists";
            WorldManagers.worldError();
        }
    }

    public static boolean worldExists(String name) {
        return Bukkit.getWorld((String)name) != null;
    }

    public static void worldError() {
        Skript.error((String)(Skript.SKRIPT_PREFIX + "Error occured within WorldManager'" + error + "'"));
    }

    static {
        worldList = new String[0];
    }
}

