/*
 * Decompiled with CFR 0.152.
 */
package uk.co.umbaska.Utils;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Scatter {
    World world;
    final Plugin p;
    int radius;
    int x;
    int z;
    int delay = 20;
    Entity[] players;
    ItemStack[] badBlocks;

    public Scatter(Plugin p, World world, int radius, int x, int z, ItemStack[] badBlocks, int delay, Entity[] players) {
        this.world = world;
        this.p = p;
        this.radius = radius;
        this.x = x;
        this.z = z;
        this.badBlocks = badBlocks;
        this.delay = delay;
        this.players = players;
        this.scatter();
    }

    public Scatter(Plugin p, int radius, Location loc, ItemStack[] badBlocks, int delay, Entity[] players) {
        this.world = loc.getWorld();
        this.p = p;
        this.radius = radius;
        this.x = loc.getBlockX();
        this.z = loc.getBlockZ();
        this.badBlocks = badBlocks;
        this.delay = delay;
        this.players = players;
        this.scatter();
    }

    private void scatter() {
        Random random = new Random();
        final double randomAngle = random.nextDouble() * Math.PI * 2.0;
        final double newradius = (double)this.radius * random.nextDouble();
        final int[] coords = this.convertFromRadiansToBlock(newradius, randomAngle);
        Bukkit.getScheduler().runTaskTimer(this.p, new Runnable(){
            int count = -1;

            @Override
            public void run() {
                ++this.count;
                Entity e = Scatter.this.players[this.count];
                Scatter.this.scatterPlayerRandom(e, randomAngle, newradius, coords);
            }
        }, (long)this.delay, (long)this.delay);
    }

    public void scatterPlayerRandom(final Entity p, final double angle, final double newrad, final int[] coords) {
        final Location finalTeleport = new Location(this.world, 0.0, 0.0, 0.0);
        finalTeleport.setX((double)coords[0]);
        finalTeleport.setZ((double)coords[1]);
        finalTeleport.setX(finalTeleport.getX() + (double)this.x);
        finalTeleport.setZ(finalTeleport.getZ() + (double)this.z);
        finalTeleport.setX((double)Math.round(finalTeleport.getX()) + 0.5);
        finalTeleport.setZ((double)Math.round(finalTeleport.getZ()) + 0.5);
        if (!this.world.getChunkAt(finalTeleport).isLoaded()) {
            this.world.getChunkAt(finalTeleport).load(true);
        }
        final Location loc = finalTeleport;
        final Plugin plug = this.p;
        final World worlds = this.world;
        Bukkit.getScheduler().runTaskLater(this.p, new Runnable(){
            Location finalTeleport2;
            {
                this.finalTeleport2 = loc;
            }

            @Override
            public void run() {
                worlds.getChunkAt(this.finalTeleport2).load(true);
                this.finalTeleport2.setY((double)Scatter.this.getSafeY(this.finalTeleport2));
                Location blockUnder = this.finalTeleport2;
                blockUnder.setY((double)(blockUnder.getBlockY() - 1));
                ArrayList<Material> banned = new ArrayList<Material>();
                if (Scatter.this.badBlocks.length > 0) {
                    for (ItemStack b : Scatter.this.badBlocks) {
                        banned.add(b.getType());
                    }
                }
                if (this.finalTeleport2.getBlock().getType() != Material.AIR) {
                    this.finalTeleport2.setY((double)Scatter.this.getSafeY(this.finalTeleport2));
                }
                for (Material ban : banned) {
                    if (blockUnder.getBlock().getType() != ban && this.finalTeleport2.getBlock().getType() != ban) continue;
                    Scatter.this.scatterPlayerRandom(p, angle, newrad, coords);
                    return;
                }
                Bukkit.getScheduler().runTaskLater(plug, new Runnable(){

                    @Override
                    public void run() {
                        p.teleport(finalTeleport);
                    }
                }, 20L);
            }
        }, 40L);
    }

    private int getSafeY(Location loc) {
        return loc.getWorld().getHighestBlockYAt(loc);
    }

    private int[] convertFromRadiansToBlock(double radius, double angle) {
        return new int[]{(int)Math.round(radius * Math.cos(angle)), (int)Math.round(radius * Math.sin(angle))};
    }
}

