/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.Dispatcher;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.RawStreamListener;
import twitter4j.SiteStreamsListener;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStreamBase;
import twitter4j.StreamController;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;

final class SiteStreamsImpl
extends StatusStreamBase {
    private final StreamController cs;
    private static final ThreadLocal<Long> forUser = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 0L;
        }
    };
    protected static final RawStreamListener[] EMPTY = new RawStreamListener[0];

    SiteStreamsImpl(Dispatcher dispatcher, InputStream stream, Configuration conf, StreamController cs) throws IOException {
        super(dispatcher, stream, conf);
        this.cs = cs;
    }

    SiteStreamsImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf, StreamController cs) throws IOException {
        super(dispatcher, response, conf);
        this.cs = cs;
    }

    @Override
    protected String parseLine(String line) {
        if ("".equals(line) || line == null) {
            return line;
        }
        int userIdEnd = line.indexOf(44, 12);
        if (this.cs.getControlURI() == null && line.charAt(2) == 'c' && line.charAt(3) == 'o' && line.charAt(4) == 'n') {
            JSONObject control = null;
            try {
                control = new JSONObject(line);
                this.cs.setControlURI(String.valueOf(this.CONF.getSiteStreamBaseURL()) + control.getJSONObject("control").getString("control_uri"));
                logger.info("control_uri: " + this.cs.getControlURI());
            }
            catch (JSONException e) {
                logger.warn("received unexpected event:" + line);
            }
            return null;
        }
        if (line.charAt(2) == 'd') {
            return line;
        }
        if (line.charAt(12) == '\"') {
            forUser.set(Long.parseLong(line.substring(13, userIdEnd - 1)));
        } else {
            forUser.set(Long.parseLong(line.substring(12, userIdEnd)));
        }
        return line.substring(userIdEnd + 11, line.length() - 1);
    }

    @Override
    protected void onClose() {
        this.cs.setControlURI(null);
    }

    @Override
    protected void onMessage(String rawString, RawStreamListener[] listeners) throws TwitterException {
        RawStreamListener[] rawStreamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            RawStreamListener listener = rawStreamListenerArray[n2];
            listener.onMessage(rawString);
            ++n2;
        }
    }

    @Override
    protected void onStatus(JSONObject json, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onStatus(forUser.get(), this.asStatus(json));
            ++n2;
        }
    }

    @Override
    protected void onDelete(JSONObject json, StreamListener[] listeners) throws JSONException {
        JSONObject deletionNotice = json.getJSONObject("delete");
        if (deletionNotice.has("status")) {
            StreamListener[] streamListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                StreamListener listener = streamListenerArray[n2];
                ((SiteStreamsListener)listener).onDeletionNotice(forUser.get(), new StatusDeletionNoticeImpl(deletionNotice.getJSONObject("status")));
                ++n2;
            }
        } else {
            JSONObject directMessage = deletionNotice.getJSONObject("direct_message");
            StreamListener[] streamListenerArray = listeners;
            int n = listeners.length;
            int n3 = 0;
            while (n3 < n) {
                StreamListener listener = streamListenerArray[n3];
                ((SiteStreamsListener)listener).onDeletionNotice(forUser.get(), ParseUtil.getInt("id", directMessage), ParseUtil.getLong("user_id", directMessage));
                ++n3;
            }
        }
    }

    @Override
    protected void onDirectMessage(JSONObject json, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onDirectMessage(forUser.get(), this.asDirectMessage(json));
            ++n2;
        }
    }

    @Override
    protected void onFriends(JSONObject json, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onFriendList(forUser.get(), this.asFriendList(json));
            ++n2;
        }
    }

    @Override
    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onFavorite(forUser.get(), this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUnfavorite(forUser.get(), this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    protected void onFollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onFollow(forUser.get(), this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    protected void onUnfollow(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUnfollow(forUser.get(), this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListMemberAddition(forUser.get(), this.asUser(addedMember), this.asUser(owner), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListMemberDeletion(forUser.get(), this.asUser(deletedMember), this.asUser(owner), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListSubscription(forUser.get(), this.asUser(source), this.asUser(owner), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListUnsubscription(forUser.get(), this.asUser(source), this.asUser(owner), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserListCreation(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListCreation(forUser.get(), this.asUser(source), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserListUpdated(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException, JSONException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListUpdate(forUser.get(), this.asUser(source), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserListDestroyed(JSONObject source, JSONObject userList, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserListDeletion(forUser.get(), this.asUser(source), this.asUserList(userList));
            ++n2;
        }
    }

    @Override
    protected void onUserUpdate(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserProfileUpdate(forUser.get(), this.asUser(source));
            ++n2;
        }
    }

    @Override
    protected void onUserSuspension(long target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserSuspension(forUser.get(), target);
            ++n2;
        }
    }

    @Override
    protected void onUserDeletion(long target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUserDeletion(forUser.get(), target);
            ++n2;
        }
    }

    @Override
    protected void onBlock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onBlock(forUser.get(), this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    protected void onUnblock(JSONObject source, JSONObject target, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onUnblock(forUser.get(), this.asUser(source), this.asUser(target));
            ++n2;
        }
    }

    @Override
    void onRetweetedRetweet(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onRetweetedRetweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    void onFavoritedRetweet(JSONObject source, JSONObject target, JSONObject targetObject, StreamListener[] listeners) throws TwitterException {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onFavoritedRetweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
            ++n2;
        }
    }

    @Override
    public void onException(Exception ex, StreamListener[] listeners) {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            listener.onException(ex);
            ++n2;
        }
    }

    @Override
    public void next(StatusListener listener) throws TwitterException {
        this.handleNextElement(new StatusListener[]{listener}, EMPTY);
    }

    @Override
    public void next(StreamListener[] listeners, RawStreamListener[] rawStreamListeners) throws TwitterException {
        this.handleNextElement(listeners, rawStreamListeners);
    }

    @Override
    public void onDisconnectionNotice(String line, StreamListener[] listeners) {
        StreamListener[] streamListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            StreamListener listener = streamListenerArray[n2];
            ((SiteStreamsListener)listener).onDisconnectionNotice(line);
            ++n2;
        }
    }
}

