/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.util;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class TimeSpanConverter
implements Serializable {
    private static final int ONE_HOUR_IN_SECONDS = 3600;
    private static final int ONE_DAY_IN_SECONDS = 86400;
    private static final int ONE_MONTH_IN_SECONDS = 2592000;
    private static final long serialVersionUID = 8665013607650804076L;
    private final MessageFormat[] formats = new MessageFormat[6];
    private final SimpleDateFormat dateMonth;
    private final SimpleDateFormat dateMonthYear;
    private static final int NOW = 0;
    private static final int N_SECONDS_AGO = 1;
    private static final int A_MINUTE_AGO = 2;
    private static final int N_MINUTES_AGO = 3;
    private static final int AN_HOUR_AGO = 4;
    private static final int N_HOURS_AGO = 5;

    public TimeSpanConverter() {
        this(Locale.getDefault());
    }

    public TimeSpanConverter(Locale locale) {
        String language = locale.getLanguage();
        if ("it".equals(language)) {
            this.formats[0] = new MessageFormat("Ora");
            this.formats[1] = new MessageFormat("{0} secondi fa");
            this.formats[2] = new MessageFormat("1 minuto fa");
            this.formats[3] = new MessageFormat("{0} minuti fa");
            this.formats[4] = new MessageFormat("1 ora fa");
            this.formats[5] = new MessageFormat("{0} ore fa");
            this.dateMonth = new SimpleDateFormat("d MMM", locale);
            this.dateMonthYear = new SimpleDateFormat("d MMM yy", locale);
        } else if ("kr".equals(language)) {
            this.formats[0] = new MessageFormat("\u00ec\u00a7\u20ac\u00ea\u00b8\u02c6");
            this.formats[1] = new MessageFormat("{0}\u00ec\u00b4\u02c6 \u00ec\u00a0\u201e");
            this.formats[2] = new MessageFormat("1\u00eb\u00b6\u201e \u00ec\u00a0\u201e");
            this.formats[3] = new MessageFormat("{0}\u00eb\u00b6\u201e \u00ec\u00a0\u201e");
            this.formats[4] = new MessageFormat("1\u00ec\u2039\u0153\u00ea\u00b0\u201e \u00ec\u00a0\u201e");
            this.formats[5] = new MessageFormat("{0} ore fa");
            this.dateMonth = new SimpleDateFormat("M\u00ec\u203a\u201d d\u00ec\ufffd\u00bc", locale);
            this.dateMonthYear = new SimpleDateFormat("yy\u00eb\u2026\u201e M\u00ec\u203a\u201d d\u00ec\ufffd\u00bc", locale);
        } else if ("es".equals(language)) {
            this.formats[0] = new MessageFormat("Ahora");
            this.formats[1] = new MessageFormat("hace {0} segundos");
            this.formats[2] = new MessageFormat("hace 1 minuto");
            this.formats[3] = new MessageFormat("hace {0} minutos");
            this.formats[4] = new MessageFormat("hace 1 hora");
            this.formats[5] = new MessageFormat("hace {0} horas");
            this.dateMonth = new SimpleDateFormat("d MMM", locale);
            this.dateMonthYear = new SimpleDateFormat("d MMM yy", locale);
        } else if ("fr".equals(language)) {
            this.formats[0] = new MessageFormat("Maintenant");
            this.formats[1] = new MessageFormat("Il y a {0} secondes");
            this.formats[2] = new MessageFormat("Il y a 1 minute");
            this.formats[3] = new MessageFormat("Il y a {0} minutes");
            this.formats[4] = new MessageFormat("Il y a 1 heure");
            this.formats[5] = new MessageFormat("Il y a {0} heures");
            this.dateMonth = new SimpleDateFormat("d MMM", locale);
            this.dateMonthYear = new SimpleDateFormat("d MMM yy", locale);
        } else if ("de".equals(language)) {
            this.formats[0] = new MessageFormat("Jetzt");
            this.formats[1] = new MessageFormat("vor {0} Sekunden");
            this.formats[2] = new MessageFormat("vor 1 Minute");
            this.formats[3] = new MessageFormat("vor {0} Minuten");
            this.formats[4] = new MessageFormat("vor 1 Stunde");
            this.formats[5] = new MessageFormat("vor {0} Stunden");
            this.dateMonth = new SimpleDateFormat("d MMM", locale);
            this.dateMonthYear = new SimpleDateFormat("d MMM yy", locale);
        } else if ("ja".equals(language)) {
            this.formats[0] = new MessageFormat("\u00e4\u00bb\u0160");
            this.formats[1] = new MessageFormat("{0}\u00e7\u00a7\u2019\u00e5\u2030\ufffd");
            this.formats[2] = new MessageFormat("1\u00e5\u02c6\u2020\u00e5\u2030\ufffd");
            this.formats[3] = new MessageFormat("{0}\u00e5\u02c6\u2020\u00e5\u2030\ufffd");
            this.formats[4] = new MessageFormat("1\u00e6\u2122\u201a\u00e9\u2013\u201c\u00e5\u2030\ufffd");
            this.formats[5] = new MessageFormat("{0}\u00e6\u2122\u201a\u00e9\u2013\u201c\u00e5\u2030\ufffd");
            this.dateMonth = new SimpleDateFormat("M\u00e6\u0153\u02c6d\u00e6\u2014\u00a5", locale);
            this.dateMonthYear = new SimpleDateFormat("yy\u00e5\u00b9\u00b4M\u00e6\u0153\u02c6d\u00e6\u2014\u00a5", locale);
        } else {
            this.formats[0] = new MessageFormat("now");
            this.formats[1] = new MessageFormat("{0} seconds ago");
            this.formats[2] = new MessageFormat("1 minute ago");
            this.formats[3] = new MessageFormat("{0} minutes ago");
            this.formats[4] = new MessageFormat("1 hour ago");
            this.formats[5] = new MessageFormat("{0} hours ago");
            this.dateMonth = new SimpleDateFormat("d MMM", Locale.ENGLISH);
            this.dateMonthYear = new SimpleDateFormat("d MMM yy", Locale.ENGLISH);
        }
    }

    public String toTimeSpanString(Date date) {
        return this.toTimeSpanString(date.getTime());
    }

    public String toTimeSpanString(long milliseconds) {
        int deltaInSeconds = (int)((System.currentTimeMillis() - milliseconds) / 1000L);
        if (deltaInSeconds >= 86400) {
            if (deltaInSeconds >= 2592000) {
                return this.dateMonthYear.format(new Date(milliseconds));
            }
            return this.dateMonth.format(new Date(milliseconds));
        }
        return this.toTimeSpanString(deltaInSeconds);
    }

    private String toTimeSpanString(int deltaInSeconds) {
        if (deltaInSeconds <= 1) {
            return this.formats[0].format(null);
        }
        if (deltaInSeconds < 60) {
            return this.formats[1].format(new Object[]{deltaInSeconds});
        }
        if (deltaInSeconds < 2700) {
            int minutes = deltaInSeconds / 60;
            if (minutes == 1) {
                return this.formats[2].format(null);
            }
            return this.formats[3].format(new Object[]{minutes});
        }
        if (deltaInSeconds < 6300) {
            return this.formats[4].format(null);
        }
        int hours = (deltaInSeconds + 900) / 3600;
        return this.formats[5].format(new Object[]{hours});
    }
}

