/*
 * Decompiled with CFR 0.152.
 */
package fr.nashoba24.twittersk;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import fr.nashoba24.twittersk.CondIsPossiblySensitive;
import fr.nashoba24.twittersk.CondIsRetweeted;
import fr.nashoba24.twittersk.CondIsRetweetedByMe;
import fr.nashoba24.twittersk.CondTwitterAddonConnected;
import fr.nashoba24.twittersk.CondTwitterDiscoverableByEmail;
import fr.nashoba24.twittersk.CondTwitterFollow;
import fr.nashoba24.twittersk.CondTwitterGeoEnabled;
import fr.nashoba24.twittersk.CondTwittererExists;
import fr.nashoba24.twittersk.EffPostTweet;
import fr.nashoba24.twittersk.EffRemoveTweet;
import fr.nashoba24.twittersk.EffTwitterBlockUser;
import fr.nashoba24.twittersk.EffTwitterConnect;
import fr.nashoba24.twittersk.EffTwitterCreateFavorite;
import fr.nashoba24.twittersk.EffTwitterDeleteDirectMessage;
import fr.nashoba24.twittersk.EffTwitterFollow;
import fr.nashoba24.twittersk.EffTwitterRetweet;
import fr.nashoba24.twittersk.EffTwitterUnblockUser;
import fr.nashoba24.twittersk.EffTwitterUnfollow;
import fr.nashoba24.twittersk.EvtOnDirectMessage;
import fr.nashoba24.twittersk.EvtOnFavorite;
import fr.nashoba24.twittersk.EvtOnFavoriteRetweet;
import fr.nashoba24.twittersk.EvtOnFollow;
import fr.nashoba24.twittersk.EvtOnQuotedTweet;
import fr.nashoba24.twittersk.EvtOnReceiveStatus;
import fr.nashoba24.twittersk.EvtOnRetweetedRetweet;
import fr.nashoba24.twittersk.EvtOnUnfavorite;
import fr.nashoba24.twittersk.EvtOnUnfollow;
import fr.nashoba24.twittersk.ExprSearchTweets;
import fr.nashoba24.twittersk.ExprStatusUser;
import fr.nashoba24.twittersk.ExprTwitterAccessLevel;
import fr.nashoba24.twittersk.ExprTwitterFavoriteCount;
import fr.nashoba24.twittersk.ExprTwitterFollowersCount;
import fr.nashoba24.twittersk.ExprTwitterFollowersList;
import fr.nashoba24.twittersk.ExprTwitterFriendsList;
import fr.nashoba24.twittersk.ExprTwitterGetDirectMessage;
import fr.nashoba24.twittersk.ExprTwitterGetDirectMessages;
import fr.nashoba24.twittersk.ExprTwitterGetFavorites;
import fr.nashoba24.twittersk.ExprTwitterHomeTimeline;
import fr.nashoba24.twittersk.ExprTwitterIncomingFriendships;
import fr.nashoba24.twittersk.ExprTwitterLanguage;
import fr.nashoba24.twittersk.ExprTwitterMentionTimeline;
import fr.nashoba24.twittersk.ExprTwitterOutgoingFriendships;
import fr.nashoba24.twittersk.ExprTwitterRateLimit;
import fr.nashoba24.twittersk.ExprTwitterRateLimitRemaining;
import fr.nashoba24.twittersk.ExprTwitterRateLimitResetTime;
import fr.nashoba24.twittersk.ExprTwitterRetweets;
import fr.nashoba24.twittersk.ExprTwitterSearchUser;
import fr.nashoba24.twittersk.ExprTwitterSelfUser;
import fr.nashoba24.twittersk.ExprTwitterSleepEndTime;
import fr.nashoba24.twittersk.ExprTwitterSleepStartTime;
import fr.nashoba24.twittersk.ExprTwitterStatusByID;
import fr.nashoba24.twittersk.ExprTwitterStatusFavoriteCount;
import fr.nashoba24.twittersk.ExprTwitterStatusID;
import fr.nashoba24.twittersk.ExprTwitterStatusRetweetsCount;
import fr.nashoba24.twittersk.ExprTwitterStatusText;
import fr.nashoba24.twittersk.ExprTwitterUserByID;
import fr.nashoba24.twittersk.ExprTwitterUserByScreenName;
import fr.nashoba24.twittersk.ExprTwitterUserDescription;
import fr.nashoba24.twittersk.ExprTwitterUserID;
import fr.nashoba24.twittersk.ExprTwitterUserName;
import fr.nashoba24.twittersk.ExprTwitterUserStatusCount;
import fr.nashoba24.twittersk.ExprTwitterUserTimeline;
import fr.nashoba24.twittersk.ExprTwitterUsersBlocked;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import twitter4j.DirectMessage;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.TwitterFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserStreamListener;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterSK
extends JavaPlugin {
    private static TwitterSK instance;
    public static TwitterFactory tf;
    public static TwitterStream twitterStream;

    public void onDisable() {
        Bukkit.getLogger().info(ChatColor.translateAlternateColorCodes((char)'&', (String)"&bTwitterSK Disabled!"));
    }

    public void onEnable() {
        instance = this;
        TwitterSK.getInstance().registerAll();
        Bukkit.getLogger().info(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aTwitterSK Enabled!"));
    }

    public void registerAll() {
        Classes.registerClass((ClassInfo)new ClassInfo(User.class, "twitterer").user(new String[]{"twitterer"}).name("twitterer").parser((Parser)new Parser<User>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public User parse(String arg0, ParseContext arg1) {
                return null;
            }

            public String toString(User arg0, int arg1) {
                return "@" + arg0.getScreenName();
            }

            public String toVariableNameString(User arg0) {
                return "@" + arg0.getScreenName();
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(Status.class, "tweet").user(new String[]{"tweet"}).name("tweet").parser((Parser)new Parser<Status>(){

            public String getVariableNamePattern() {
                return ".+";
            }

            @Nullable
            public Status parse(String arg0, ParseContext arg1) {
                return null;
            }

            public String toString(Status arg0, int arg1) {
                return arg0.getText();
            }

            public String toVariableNameString(Status arg0) {
                return arg0.getText();
            }
        }));
        Skript.registerCondition(CondTwitterFollow.class, (String[])new String[]{"%twitterer% follow[s] %twitterer%"});
        Skript.registerCondition(CondIsPossiblySensitive.class, (String[])new String[]{"%tweet% is possibly sensitive"});
        Skript.registerCondition(CondIsRetweeted.class, (String[])new String[]{"%tweet% is retweeted"});
        Skript.registerCondition(CondIsRetweetedByMe.class, (String[])new String[]{"%tweet% is retweeted by me"});
        Skript.registerCondition(CondTwitterDiscoverableByEmail.class, (String[])new String[]{"twitter account is discoverable by [e]mail"});
        Skript.registerCondition(CondTwitterGeoEnabled.class, (String[])new String[]{"twitter account is geo enabled"});
        Skript.registerCondition(CondTwitterDiscoverableByEmail.class, (String[])new String[]{"%tweet% is favorited"});
        Skript.registerCondition(CondTwitterAddonConnected.class, (String[])new String[]{"addon is connected to twitter"});
        Skript.registerCondition(CondTwittererExists.class, (String[])new String[]{"(twitter user|twitterer) %string% exist[s]"});
        Skript.registerEffect(EffPostTweet.class, (String[])new String[]{"tweet %string%"});
        Skript.registerEffect(EffRemoveTweet.class, (String[])new String[]{"destroy %tweet%"});
        Skript.registerEffect(EffTwitterBlockUser.class, (String[])new String[]{"block %twitterer%"});
        Skript.registerEffect(EffTwitterConnect.class, (String[])new String[]{"twitter connect with consumer key %string%, consumer secret %string%, access token %string%( and|,) secret token %string%", "twitter debug connect with consumer key %string%, consumer secret %string%, access token %string%( and|,) secret token %string%"});
        Skript.registerEffect(EffTwitterCreateFavorite.class, (String[])new String[]{"favorite %tweet%"});
        Skript.registerEffect(EffTwitterDeleteDirectMessage.class, (String[])new String[]{"delete (direct message|dm) with id %long%"});
        Skript.registerEffect(EffTwitterCreateFavorite.class, (String[])new String[]{"unfavorite %tweet%"});
        Skript.registerEffect(EffTwitterFollow.class, (String[])new String[]{"follow %twitterer%"});
        Skript.registerEffect(EffTwitterFollow.class, (String[])new String[]{"report %twitterer% for spam[ing]"});
        Skript.registerEffect(EffTwitterRetweet.class, (String[])new String[]{"retweet %tweet%"});
        Skript.registerEffect(EffTwitterUnblockUser.class, (String[])new String[]{"(un|de)block %twitterer%"});
        Skript.registerEffect(EffTwitterUnfollow.class, (String[])new String[]{"unfollow %twitterer%"});
        Skript.registerExpression(ExprSearchTweets.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"search tweet[s] (for|with query) %string%"});
        Skript.registerExpression(ExprStatusUser.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(author|twitterer) of %tweet%"});
        Skript.registerExpression(ExprTwitterAccessLevel.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter access level"});
        Skript.registerExpression(ExprTwitterFavoriteCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"my twitter favorite count", "twitter favorite count of %twitterer%"});
        Skript.registerExpression(ExprTwitterFollowersCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"my twitter follower[s] count", "twitter follower[s] count of %twitterer%"});
        Skript.registerExpression(ExprTwitterFollowersList.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"my [twitter ]follower[s]", "[twitter ]follower[s] of %twitterer%"});
        Skript.registerExpression(ExprTwitterFollowersCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"my twitter friend[s] count", "twitter friend[s] count of %twitterer%"});
        Skript.registerExpression(ExprTwitterFriendsList.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"my twitter friend[s]", "twitter friend[s] of %twitterer%"});
        Skript.registerExpression(ExprTwitterGetDirectMessage.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(direct message|dm) with id %long%"});
        Skript.registerExpression(ExprTwitterGetDirectMessages.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"direct messages"});
        Skript.registerExpression(ExprTwitterGetFavorites.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"favo[u]rites tweets"});
        Skript.registerExpression(ExprTwitterHomeTimeline.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"home timeline"});
        Skript.registerExpression(ExprTwitterIncomingFriendships.class, Long.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"incoming friendship[s]"});
        Skript.registerExpression(ExprTwitterLanguage.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter language"});
        Skript.registerExpression(ExprTwitterMentionTimeline.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"mention timeline"});
        Skript.registerExpression(ExprTwitterRateLimit.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter rate limit"});
        Skript.registerExpression(ExprTwitterRateLimitRemaining.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter rate limit remaining"});
        Skript.registerExpression(ExprTwitterRateLimitResetTime.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter rate limit reset time"});
        Skript.registerExpression(ExprTwitterRateLimitResetTime.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter time until reset rate limit"});
        Skript.registerExpression(ExprTwitterRetweets.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"retweet[s] of %tweet%"});
        Skript.registerExpression(ExprTwitterSearchUser.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"search user[s] (for|with query) %string%"});
        Skript.registerExpression(ExprTwitterSleepEndTime.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter sleep end time"});
        Skript.registerExpression(ExprTwitterSleepStartTime.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter sleep start time"});
        Skript.registerExpression(ExprTwitterStatusByID.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"tweet with id %long%"});
        Skript.registerExpression(ExprTwitterStatusFavoriteCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"favorite[s] count of %tweet%"});
        Skript.registerExpression(ExprTwitterStatusRetweetsCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"retweet[s] count of %tweet%"});
        Skript.registerExpression(ExprTwitterStatusText.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"text of %tweet%"});
        Skript.registerExpression(ExprTwitterUserByID.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"user with id %long%"});
        Skript.registerExpression(ExprTwitterUserByScreenName.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"user with [screen ]name %string%"});
        Skript.registerExpression(ExprTwitterUserDescription.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"description of %twitterer%"});
        Skript.registerExpression(ExprTwitterUserID.class, Long.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"id of %twitterer%"});
        Skript.registerExpression(ExprTwitterUserName.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(username|screen name) of %twitterer%"});
        Skript.registerExpression(ExprTwitterUsersBlocked.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"twitter blocked users"});
        Skript.registerExpression(ExprTwitterUserStatusCount.class, Integer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"status count of %twitterer%"});
        Skript.registerExpression(ExprTwitterUserTimeline.class, Status.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"timeline of %twitterer%"});
        Skript.registerExpression(ExprTwitterOutgoingFriendships.class, Long.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"outgoing friendship[s]"});
        Skript.registerEvent((String)"Direct Message Event", SimpleEvent.class, EvtOnDirectMessage.class, (String[])new String[]{"twitter[ direct] message"});
        Skript.registerExpression(ExprTwitterStatusID.class, Long.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"id of %tweet%"});
        Skript.registerEvent((String)"Direct Message Event", SimpleEvent.class, EvtOnDirectMessage.class, (String[])new String[]{"twitter[ direct] message"});
        Skript.registerExpression(ExprTwitterSelfUser.class, User.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"my twitter account"});
        EventValues.registerEventValue(EvtOnDirectMessage.class, String.class, (Getter)new Getter<String, EvtOnDirectMessage>(){

            public String get(EvtOnDirectMessage e) {
                return e.getDirectMessage();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Favorite Event", SimpleEvent.class, EvtOnFavorite.class, (String[])new String[]{"tweet favorite[d]"});
        EventValues.registerEventValue(EvtOnFavorite.class, Status.class, (Getter)new Getter<Status, EvtOnFavorite>(){

            public Status get(EvtOnFavorite e) {
                return e.getStatus();
            }
        }, (int)0);
        EventValues.registerEventValue(EvtOnFavorite.class, User.class, (Getter)new Getter<User, EvtOnFavorite>(){

            public User get(EvtOnFavorite e) {
                return e.getSource();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Unfavorite Event", SimpleEvent.class, EvtOnUnfavorite.class, (String[])new String[]{"tweet unfavorite[d]"});
        EventValues.registerEventValue(EvtOnUnfavorite.class, Status.class, (Getter)new Getter<Status, EvtOnUnfavorite>(){

            public Status get(EvtOnUnfavorite e) {
                return e.getStatus();
            }
        }, (int)0);
        EventValues.registerEventValue(EvtOnUnfavorite.class, User.class, (Getter)new Getter<User, EvtOnUnfavorite>(){

            public User get(EvtOnUnfavorite e) {
                return e.getSource();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Favorite Retweet Event", SimpleEvent.class, EvtOnFavoriteRetweet.class, (String[])new String[]{"retweet favorite[d]"});
        EventValues.registerEventValue(EvtOnFavoriteRetweet.class, Status.class, (Getter)new Getter<Status, EvtOnFavoriteRetweet>(){

            public Status get(EvtOnFavoriteRetweet e) {
                return e.getStatus();
            }
        }, (int)0);
        EventValues.registerEventValue(EvtOnFavoriteRetweet.class, User.class, (Getter)new Getter<User, EvtOnFavoriteRetweet>(){

            public User get(EvtOnFavoriteRetweet e) {
                return e.getSource();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Follow Event", SimpleEvent.class, EvtOnFollow.class, (String[])new String[]{"follow"});
        EventValues.registerEventValue(EvtOnFollow.class, User.class, (Getter)new Getter<User, EvtOnFollow>(){

            public User get(EvtOnFollow e) {
                return e.getSource();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Quoted Status Event", SimpleEvent.class, EvtOnQuotedTweet.class, (String[])new String[]{"tweet quote[d]"});
        EventValues.registerEventValue(EvtOnQuotedTweet.class, Status.class, (Getter)new Getter<Status, EvtOnQuotedTweet>(){

            public Status get(EvtOnQuotedTweet e) {
                return e.getStatus();
            }
        }, (int)0);
        EventValues.registerEventValue(EvtOnQuotedTweet.class, User.class, (Getter)new Getter<User, EvtOnQuotedTweet>(){

            public User get(EvtOnQuotedTweet e) {
                return e.getSource();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Receive Tweet Event", SimpleEvent.class, EvtOnReceiveStatus.class, (String[])new String[]{"receive tweet"});
        EventValues.registerEventValue(EvtOnReceiveStatus.class, Status.class, (Getter)new Getter<Status, EvtOnReceiveStatus>(){

            public Status get(EvtOnReceiveStatus e) {
                return e.getStatus();
            }
        }, (int)0);
        Skript.registerEvent((String)"Twitter Retweeted Retweet Event", SimpleEvent.class, EvtOnRetweetedRetweet.class, (String[])new String[]{"retweet retweet[ed[ tweet]]"});
        EventValues.registerEventValue(EvtOnRetweetedRetweet.class, Status.class, (Getter)new Getter<Status, EvtOnRetweetedRetweet>(){

            public Status get(EvtOnRetweetedRetweet e) {
                return e.getStatus();
            }
        }, (int)0);
        EventValues.registerEventValue(EvtOnRetweetedRetweet.class, User.class, (Getter)new Getter<User, EvtOnRetweetedRetweet>(){

            public User get(EvtOnRetweetedRetweet e) {
                return e.getSource();
            }
        }, (int)0);
    }

    public static void registerEvents(boolean debug, String key, String secret, String access_token, String access_token_secret) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(debug).setOAuthConsumerKey(key).setOAuthConsumerSecret(secret).setOAuthAccessToken(access_token).setOAuthAccessTokenSecret(access_token_secret);
        TwitterStream ts = new TwitterStreamFactory(cb.build()).getInstance();
        UserStreamListener userStreamListener = new UserStreamListener(){

            @Override
            public void onDeletionNotice(StatusDeletionNotice arg0) {
            }

            @Override
            public void onScrubGeo(long arg0, long arg1) {
            }

            @Override
            public void onStallWarning(StallWarning arg0) {
            }

            @Override
            public void onStatus(Status arg0) {
                TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnReceiveStatus(arg0));
            }

            @Override
            public void onTrackLimitationNotice(int arg0) {
            }

            @Override
            public void onException(Exception arg0) {
            }

            @Override
            public void onBlock(User arg0, User arg1) {
            }

            @Override
            public void onDeletionNotice(long arg0, long arg1) {
            }

            @Override
            public void onDirectMessage(DirectMessage arg0) {
                TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnDirectMessage(arg0));
            }

            @Override
            public void onFavorite(User arg0, User arg1, Status arg2) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnFavorite(arg0, arg1, arg2));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFavoritedRetweet(User arg0, User arg1, Status arg2) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnFavoriteRetweet(arg0, arg1, arg2));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFollow(User arg0, User arg1) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnFollow(arg0));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onFriendList(long[] arg0) {
            }

            @Override
            public void onQuotedTweet(User arg0, User arg1, Status arg2) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnQuotedTweet(arg0, arg1, arg2));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onRetweetedRetweet(User arg0, User arg1, Status arg2) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnRetweetedRetweet(arg0, arg1, arg2));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onUnblock(User arg0, User arg1) {
            }

            @Override
            public void onUnfavorite(User arg0, User arg1, Status arg2) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnUnfavorite(arg0, arg1, arg2));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onUnfollow(User arg0, User arg1) {
                try {
                    TwitterSK.getInstance().getServer().getPluginManager().callEvent((Event)new EvtOnUnfollow(arg0));
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onUserDeletion(long arg0) {
            }

            @Override
            public void onUserListCreation(User arg0, UserList arg1) {
            }

            @Override
            public void onUserListDeletion(User arg0, UserList arg1) {
            }

            @Override
            public void onUserListMemberAddition(User arg0, User arg1, UserList arg2) {
            }

            @Override
            public void onUserListMemberDeletion(User arg0, User arg1, UserList arg2) {
            }

            @Override
            public void onUserListSubscription(User arg0, User arg1, UserList arg2) {
            }

            @Override
            public void onUserListUnsubscription(User arg0, User arg1, UserList arg2) {
            }

            @Override
            public void onUserListUpdate(User arg0, UserList arg1) {
            }

            @Override
            public void onUserProfileUpdate(User arg0) {
            }

            @Override
            public void onUserSuspension(long arg0) {
            }
        };
        ts.addListener(userStreamListener);
        ts.user();
        twitterStream = ts;
    }

    public static TwitterSK getInstance() {
        return instance;
    }
}

