/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.util;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import me.tuke.sktuke.util.EffectSection;
import me.tuke.sktuke.util.ReflectionUtils;
import org.bukkit.event.Event;

public class Registry {
    private static int evt = 0;
    private static int cond = 0;
    private static int eff = 0;
    private static int expr = 0;
    public static int typ = 0;

    public static Integer[] getResults() {
        return new Integer[]{evt, cond, eff, expr, typ};
    }

    public static void newSimple(Class<?> expr, String ... syntaxes) {
        Registry.newExpression(expr, 1, ExpressionType.SIMPLE, syntaxes);
    }

    public static void newSimple(Class<?> expr, int amount, String ... syntaxes) {
        Registry.newExpression(expr, amount, ExpressionType.SIMPLE, syntaxes);
    }

    public static void newProperty(Class<?> expr, String property, String from) {
        Registry.newProperty(expr, 1, property, from);
    }

    public static void newProperty(Class<?> expr, int amount, String property, String from) {
        Registry.newExpression(expr, amount, ExpressionType.PROPERTY, "[the] " + property + " of %" + from + "%", "%" + from + "%'[s] " + property);
    }

    public static void newCombined(Class<?> expr, String ... syntaxes) {
        Registry.newExpression(expr, 1, ExpressionType.COMBINED, syntaxes);
    }

    public static void newCombined(Class<?> expr, int amount, String ... syntaxes) {
        Registry.newExpression(expr, amount, ExpressionType.COMBINED, syntaxes);
    }

    public static void newMatchesEverything(Class<?> expr, String ... syntaxes) {
        Registry.newExpression(expr, 1, ExpressionType.PATTERN_MATCHES_EVERYTHING, syntaxes);
    }

    public static void newMatchesEverything(Class<?> expr, int amount, String ... syntaxes) {
        Registry.newExpression(expr, amount, ExpressionType.PATTERN_MATCHES_EVERYTHING, syntaxes);
    }

    private static <E extends Expression<T>, T> void newExpression(Class<?> expression, int amount, ExpressionType type, String ... syntaxes) {
        if (Skript.isAcceptRegistrations()) {
            Expression exp;
            Class<?> clz;
            Class<Object> clazz = clz = Expression.class.isAssignableFrom(expression) ? expression : null;
            if (clz != null && (exp = (Expression)ReflectionUtils.newInstance(clz)) != null) {
                Skript.registerExpression(clz, (Class)exp.getReturnType(), (ExpressionType)type, (String[])syntaxes);
                expr += amount;
            }
        }
    }

    public static void newEffect(Class<?> eff, String ... syntaxes) {
        Registry.newEffect(eff, 1, syntaxes);
    }

    public static void newEffect(Class<?> eff, int amount, String ... syntaxes) {
        if (Skript.isAcceptRegistrations()) {
            if (EffectSection.class.isAssignableFrom(eff)) {
                Skript.registerCondition(eff, (String[])syntaxes);
            } else if (Effect.class.isAssignableFrom(eff)) {
                Skript.registerEffect(eff, (String[])syntaxes);
            }
            Registry.eff += amount;
        }
    }

    public static void newCondition(Class<?> cond, String ... syntaxes) {
        Registry.newCondition(cond, 1, syntaxes);
    }

    public static void newCondition(Class<?> cond, int amount, String ... syntaxes) {
        if (Skript.isAcceptRegistrations() && Condition.class.isAssignableFrom(cond)) {
            Skript.registerCondition(cond, (String[])syntaxes);
            Registry.cond += amount;
        }
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> newEvent(Class<E> evt, Class<? extends Event> event, String name, String ... syntaxes) {
        return Registry.newEvent(evt, event, 1, name, syntaxes);
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> newEvent(Class<E> evt, Class<? extends Event> event, int amount, String name, String ... syntaxes) {
        if (Skript.isAcceptRegistrations()) {
            Registry.evt += amount;
            return Skript.registerEvent((String)name, evt, event, (String[])syntaxes);
        }
        return null;
    }
}

