/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.manager.recipe;

import ch.njol.skript.Skript;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.util.Pair;
import me.tuke.sktuke.TuSKe;
import me.tuke.sktuke.manager.recipe.CustomFurnaceRecipe;
import me.tuke.sktuke.manager.recipe.CustomShapedRecipe;
import me.tuke.sktuke.manager.recipe.CustomShapelessRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class RecipeManager
implements Listener {
    private Set<Recipe> recipes = new HashSet<Recipe>();
    private Map<Object, Recipe> keys = Skript.isRunningMinecraft((int)1, (int)12) ? new HashMap() : null;

    @EventHandler(priority=EventPriority.LOW)
    public void onPrepare(PrepareItemCraftEvent e) {
        Pair<Integer, Recipe> pair = this.getMatchingRecipe(e.getInventory().getMatrix());
        if ((Integer)pair.getKey() == 0) {
            e.getInventory().setResult(new ItemStack(Material.AIR));
        } else if ((Integer)pair.getKey() == 1) {
            e.getInventory().setResult(((Recipe)pair.getValue()).getResult());
            Bukkit.getScheduler().runTaskLater((Plugin)TuSKe.getInstance(), () -> ((Player)e.getView().getPlayer()).updateInventory(), 12L);
        }
    }

    public void registerRecipe(Recipe rec, boolean uniqueIngredients) {
        if (uniqueIngredients && (rec instanceof CustomShapedRecipe || rec instanceof CustomShapelessRecipe || rec instanceof CustomFurnaceRecipe)) {
            if (this.getIfContainsCustomRecipe(rec.getResult(), this.getIngredients(rec)) != null || !Bukkit.addRecipe((Recipe)rec) || rec instanceof CustomFurnaceRecipe) {
                return;
            }
            this.recipes.add(rec);
            if (this.recipes.size() == 1) {
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TuSKe.getInstance());
            }
        } else {
            Bukkit.addRecipe((Recipe)rec);
        }
        if (this.keys != null && this.keys.size() > 0 && rec instanceof Keyed) {
            this.keys.put(((Keyed)rec).getKey(), rec);
        }
    }

    public Pair<Integer, Recipe> getMatchingRecipe(ItemStack ... ingredients) {
        int matchingLevel = -1;
        Recipe r = null;
        for (Recipe recipe : this.recipes) {
            int count = this.equalsRecipe(recipe, ingredients);
            if (count < 0) continue;
            r = recipe;
            matchingLevel = count;
            if (matchingLevel <= 0) continue;
            break;
        }
        return new Pair((Object)matchingLevel, r);
    }

    public Recipe getCustomRecipe(Recipe rec) {
        return this.getIfContainsCustomRecipe(rec.getResult(), this.getIngredients(rec));
    }

    public void removeRecipe(Recipe ... recipes) {
        if (recipes == null || recipes.length == 0) {
            return;
        }
        Iterator it = Bukkit.recipeIterator();
        block0: while (it.hasNext()) {
            Recipe r = (Recipe)it.next();
            for (int x = 0; x < recipes.length; ++x) {
                ItemStack[] ingredients;
                if (!r.getResult().equals((Object)recipes[x].getResult()) || this.equalsRecipe(r, ingredients = this.getIngredients(recipes[x])) != 1) continue;
                this.removeCustomRecipe(r);
                it.remove();
                recipes[x] = null;
                if (this.keys != null && r instanceof Keyed) {
                    this.keys.remove(((Keyed)r).getKey());
                }
                if (x == recipes.length) continue block0;
            }
        }
    }

    public Recipe getIfContainsCustomRecipe(ItemStack result, ItemStack[] items) {
        Recipe rec = null;
        for (Recipe recipe : this.recipes) {
            int matchingLevel;
            if (!result.equals((Object)recipe.getResult()) || (matchingLevel = this.equalsRecipe(recipe, items)) < 0) continue;
            rec = recipe;
            if (matchingLevel <= 0) continue;
            break;
        }
        return rec;
    }

    public int equalsRecipe(Recipe rec, ItemStack[] items) {
        if (rec == null || items == null || items.length == 0) {
            return -1;
        }
        if (rec instanceof ShapedRecipe) {
            Map map = rec instanceof CustomShapedRecipe ? ((CustomShapedRecipe)rec).getIngredientsMap() : ((ShapedRecipe)rec).getIngredientMap();
            int length = ((ShapedRecipe)rec).getShape()[0].length();
            boolean is2x2 = items.length < 9;
            char ch = 'a';
            int count = -1;
            int slot = 0;
            for (int x = 0; x < items.length && x < items.length; ++x) {
                ItemStack item = (ItemStack)map.get(Character.valueOf(ch));
                if (item != null) {
                    int y = this.areEqual(item, items[x]);
                    if (y == 1 && count == -1 || y == 0) {
                        count = y;
                    }
                    if (y >= 0) {
                        ch = (char)(ch + '\u0001');
                        if (++slot != length) continue;
                        slot = 0;
                        if (is2x2) {
                            x += 2 - length;
                            continue;
                        }
                        x += 3 - length;
                        continue;
                    }
                    if (ch <= 97) continue;
                    return -1;
                }
                if (ch <= 97 || this.isAir(items[x])) continue;
                return -1;
            }
            return map.size() == ch - 97 ? count : -1;
        }
        if (rec instanceof ShapelessRecipe) {
            List ingredients = ((ShapelessRecipe)rec).getIngredientList();
            int count = 1;
            Iterator iterator = ingredients.iterator();
            if (iterator.hasNext()) {
                ItemStack item1 = (ItemStack)iterator.next();
                int match = -1;
                int y = -1;
                for (int x = 0; x < items.length; ++x) {
                    if (this.isAir(items[x]) || (y = this.areEqual(item1, items[x])) < 0) continue;
                    match = x;
                    if (y == 1) break;
                }
                if (match >= 0) {
                    items[match] = null;
                    if (y < count) {
                        count = y;
                    }
                } else {
                    return -1;
                }
            }
            return count;
        }
        return -1;
    }

    public boolean isAir(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }

    public int areEqual(ItemStack item1, ItemStack item2) {
        if (this.isAir(item1) && this.isAir(item2)) {
            return 1;
        }
        if (item1 == null || item2 == null) {
            return -1;
        }
        if (item1.getDurability() == Short.MAX_VALUE || item2.getDurability() == Short.MAX_VALUE) {
            item1.setDurability(item2.getDurability());
        }
        if (item1.getType().equals((Object)item2.getType()) && item1.getDurability() == item2.getDurability() && item1.getAmount() <= item2.getAmount()) {
            if (!item1.hasItemMeta() && !item2.hasItemMeta() || item1.hasItemMeta() && item2.hasItemMeta() && Bukkit.getItemFactory().equals(item1.getItemMeta(), item2.getItemMeta())) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public ItemStack[] getIngredients(Recipe rec) {
        if (rec instanceof CustomShapedRecipe) {
            return ((CustomShapedRecipe)rec).getIngredients();
        }
        if (rec instanceof CustomShapelessRecipe) {
            return ((CustomShapelessRecipe)rec).getIngredients();
        }
        if (rec instanceof CustomFurnaceRecipe) {
            return new ItemStack[]{((CustomFurnaceRecipe)rec).getSource()};
        }
        if (rec instanceof ShapedRecipe) {
            Map map = ((ShapedRecipe)rec).getIngredientMap();
            return map.values().toArray(new ItemStack[map.size()]);
        }
        if (rec instanceof ShapelessRecipe) {
            List items = ((ShapelessRecipe)rec).getIngredientList();
            return items.toArray(new ItemStack[items.size()]);
        }
        return new ItemStack[]{((FurnaceRecipe)rec).getInput()};
    }

    public ItemStack[] getShapedIngredients(ShapedRecipe sr) {
        ItemStack[] items;
        Map map = sr.getIngredientMap();
        if (map.size() < 9) {
            items = new ItemStack[9];
            String[] shape = sr.getShape();
            int x = 0;
            for (String str : shape) {
                char[] cArray = str.toCharArray();
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    Character ch = Character.valueOf(cArray[i]);
                    items[x++] = (ItemStack)map.get(ch);
                }
                x += 3 - str.length();
            }
        } else {
            items = map.values().toArray(new ItemStack[map.size()]);
        }
        return this.fixIngredients(items);
    }

    public ItemStack[] fixIngredients(ItemStack[] items) {
        for (int x = 0; x < items.length; ++x) {
            items[x] = this.fixItem(items[x]);
        }
        return items;
    }

    private ItemStack fixItem(ItemStack item) {
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        if (item.getDurability() == Short.MAX_VALUE) {
            item.setDurability((short)0);
        }
        if (item.getAmount() <= 0) {
            item.setAmount(1);
        }
        return item;
    }

    public void removeCustomRecipe(Recipe ... recs) {
        for (Recipe r : recs) {
            Recipe rec = this.getCustomRecipe(r);
            if (rec == null) continue;
            this.recipes.remove(rec);
        }
        if (this.recipes.size() == 0) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void clearRecipes() {
        HandlerList.unregisterAll((Listener)this);
        this.recipes.clear();
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    public CustomShapedRecipe newShapedRecipe(ItemStack result, ItemStack[] items, String ... shapes) {
        if (this.keys == null) {
            return new CustomShapedRecipe(result, items, UUID.randomUUID().toString(), shapes);
        }
        return new CustomShapedRecipe(result, items, shapes);
    }

    public CustomShapelessRecipe newShapelessRecipe(ItemStack result, ItemStack[] items) {
        if (this.keys == null) {
            return new CustomShapelessRecipe(result, items, UUID.randomUUID().toString());
        }
        return new CustomShapelessRecipe(result, items);
    }

    public Recipe getRecipeFromKey(Object key) {
        if (this.keys != null && key != null) {
            Recipe result = this.keys.get(key);
            if (result == null) {
                Iterator recipes = Bukkit.recipeIterator();
                this.keys.clear();
                while (recipes.hasNext()) {
                    Recipe r = (Recipe)recipes.next();
                    if (!(r instanceof Keyed)) continue;
                    this.keys.put(((Keyed)r).getKey(), r);
                    if (!((Keyed)r).getKey().equals(key)) continue;
                    result = r;
                }
            }
            return result;
        }
        return null;
    }
}

