/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.manager.recipe;

import java.util.HashMap;
import java.util.Map;
import me.tuke.sktuke.TuSKe;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class CustomShapedRecipe
extends ShapedRecipe {
    private Map<Character, ItemStack> map = new HashMap<Character, ItemStack>();

    public CustomShapedRecipe(ItemStack r, ItemStack[] items, String ... shapes) {
        super(r);
        this.setIngredients(items, shapes);
    }

    public CustomShapedRecipe(ItemStack r, ItemStack[] items, String key, String ... shapes) {
        super(new NamespacedKey((Plugin)TuSKe.getInstance(), key), r);
        this.setIngredients(items, shapes);
    }

    public Map<Character, ItemStack> getIngredientsMap() {
        return this.map.size() == 0 ? super.getIngredientMap() : this.map;
    }

    public ItemStack[] getIngredients() {
        return this.map.values().toArray(new ItemStack[this.map.size()]);
    }

    private void setIngredients(ItemStack[] items, String[] shapes) {
        for (int x = 0; x < shapes.length; ++x) {
            shapes[x] = shapes[x].toLowerCase();
            if (shapes[x] != null && shapes[x].matches("[a-i\\s]{1,3}")) continue;
            return;
        }
        this.shape(shapes);
        char c = 'a';
        for (int x = 0; x < items.length; ++x) {
            ItemStack item = items[x];
            try {
                this.setIngredient(c, item.getData());
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = (char)(c + '\u0001');
        }
        this.setupShape(shapes, items);
    }

    private void setupShape(String[] shapes, ItemStack[] items) {
        char ch1 = 'a';
        for (String shape : shapes) {
            for (char ch2 : shape.toCharArray()) {
                if (ch2 - 97 < items.length) {
                    ItemStack item = items[ch2 - 97];
                    if (item != null) {
                        this.map.put(Character.valueOf(ch1), item);
                    } else {
                        this.map.put(Character.valueOf(ch1), new ItemStack(Material.AIR));
                    }
                }
                ch1 = (char)(ch1 + 1);
            }
        }
    }
}

