/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.recipe;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.tuke.sktuke.util.Registry;
import org.bukkit.Keyed;
import org.bukkit.inventory.Recipe;

@Name(value="Recipe ID")
@Description(value={"Starting from minecraft 1.18, the recipes now has a unique id. Recipes registered by minecraft will have a id `minecraft:%the result item's name%`, an old recipe plugin will be `bukkit:%random uuid%`, while TuSKe will have its id as `tuske:%last recipe id + 1%`. Other plugins may have a different format, but always following `<plugin>:<key>`.**Only for Shaped and Shapeless recipes**"})
@Examples(value={"loop recipes of held item:", "\tadd \"{recipeBook:{recipes:[\"%recipe id of loop-recipe%\"]}}\" to player's nbt"})
@Since(value="1.8")
public class ExprRecipeID
extends SimplePropertyExpression<Recipe, String> {
    protected String getPropertyName() {
        return "recipe id";
    }

    public String convert(Recipe recipe) {
        return recipe instanceof Keyed ? ((Keyed)recipe).getKey() + "" : null;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        Registry.newProperty(ExprRecipeID.class, "recipe (id|name|key)", "recipes");
    }
}

