/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions.recipe;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import me.tuke.sktuke.util.Registry;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;

@Name(value="Knowledge Book")
@Description(value={"It returns a knowledge book (1.12+ only) with given recipes."})
@Examples(value={"#Make sure you have an updated aliases containing 'knowledge book'.", "give knowledge book with all recipes to player", "give knowledge book with all recipes of held item to player"})
@Since(value="1.8")
public class ExprKnowledgeBook
extends SimpleExpression<ItemStack> {
    private Expression<ItemStack> item;
    private Expression<Recipe> recipes;

    protected ItemStack[] get(Event event) {
        ItemStack item = (ItemStack)this.item.getSingle(event);
        if (item != null && item.getType() == Material.KNOWLEDGE_BOOK) {
            Recipe[] recipes;
            KnowledgeBookMeta meta = (KnowledgeBookMeta)(item.hasItemMeta() ? item.getItemMeta().clone() : Bukkit.getItemFactory().getItemMeta(Material.KNOWLEDGE_BOOK));
            for (Recipe recipe : recipes = (Recipe[])this.recipes.getArray(event)) {
                if (!(recipe instanceof Keyed)) continue;
                meta.addRecipe(new NamespacedKey[]{((Keyed)recipe).getKey()});
            }
            item = item.clone();
            item.setItemMeta((ItemMeta)meta);
            return new ItemStack[]{item};
        }
        return new ItemStack[0];
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public String toString(Event event, boolean b) {
        return this.item.toString(event, b) + " with recipes " + this.recipes.toString(event, b);
    }

    public boolean init(Expression<?>[] arg, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.item = arg[0];
        this.recipes = arg[1];
        return true;
    }

    static {
        if (Skript.isRunningMinecraft((int)1, (int)12)) {
            Registry.newCombined(ExprKnowledgeBook.class, "%itemstack% with [recipes] %recipes%");
        }
    }
}

