/*
 * Decompiled with CFR 0.152.
 */
package me.tuke.sktuke.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import me.tuke.sktuke.util.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Rabbit;
import org.bukkit.event.Event;

@Name(value="Rabbit Type")
@Description(value={"Returns the type of rabbit. e.g. `black`, `black and white`, `brown`, `gold`, `salt and pepper`, `the killer bunny` and `white`."})
@Examples(value={"on spawn of rabbit:", "\tif rabbit type of event-entity is \"the killer bunny\":", "\t\tbroadcast \"Run, everyone, run! The Killer Bunny was spawned!\""})
@Since(value="1.0")
public class ExprRabbitType
extends SimplePropertyExpression<Entity, String> {
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Nullable
    public String convert(Entity e) {
        if (e instanceof Rabbit) {
            return ((Rabbit)e).getRabbitType().name().toLowerCase().replaceAll("_", " ");
        }
        return null;
    }

    protected String getPropertyName() {
        return "rabbit type";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Entity le = ((Entity[])this.getExpr().getArray(e))[0];
        if (le != null) {
            String s = ((String)delta[0]).toUpperCase().replaceAll(" ", "_");
            if (le instanceof Rabbit && mode == Changer.ChangeMode.SET && Rabbit.Type.valueOf((String)s) != null) {
                ((Rabbit)le).setRabbitType(Rabbit.Type.valueOf((String)s));
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprRabbitType.class, "rabbit type", "entity");
    }
}

