/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions.gui;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.slot.CursorSlot;
import ch.njol.skript.util.slot.InventorySlot;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.manager.gui.v2.GUIHandler;
import com.github.tukenuke.tuske.manager.gui.v2.GUIInventory;
import com.github.tukenuke.tuske.sections.gui.EffFormatGUI;
import com.github.tukenuke.tuske.sections.gui.EffMakeGUI;
import com.github.tukenuke.tuske.sections.gui.EffOnCloseGUI;
import com.github.tukenuke.tuske.util.EffectSection;
import com.github.tukenuke.tuske.util.InventoryUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ExprGUIValue
extends SimpleExpression<Object> {
    private int type = -1;
    private String toString = "gui-value";
    private boolean isDelayed = false;
    private boolean isOldGui = false;
    private Changer<Slot> changer = null;

    public Class<? extends Object> getReturnType() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return Number.class;
            }
            case 3: {
                return Inventory.class;
            }
            case 4: {
                return InventoryAction.class;
            }
            case 5: {
                return ClickType.class;
            }
            case 6: 
            case 7: {
                return ItemStack.class;
            }
            case 8: {
                return InventoryType.SlotType.class;
            }
            case 9: 
            case 10: {
                return Player.class;
            }
            case 11: 
            case 12: {
                return String.class;
            }
            case 13: {
                return GUIInventory.class;
            }
        }
        return Object.class;
    }

    public boolean isSingle() {
        return this.type != 10;
    }

    public boolean init(Expression<?>[] arg0, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (!EffectSection.isCurrentSection(EffMakeGUI.class, EffFormatGUI.class, EffOnCloseGUI.class)) {
            Skript.error((String)("You can't use '" + arg3.expr + "' outside of a 'make gui', 'format gui slot' or 'run when close' section."));
            return false;
        }
        if (EffectSection.isCurrentSection(EffFormatGUI.class)) {
            this.isOldGui = true;
        }
        this.isDelayed = arg2.isTrue();
        this.type = arg1;
        this.toString = arg3.expr;
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return this.toString;
    }

    @Nullable
    protected Object[] get(Event e) {
        GUIInventory gui;
        GUIInventory gUIInventory = gui = !this.isOldGui ? GUIHandler.getInstance().getGUIEvent(e) : null;
        if (e instanceof InventoryClickEvent) {
            if (!this.isOldGui && gui == null) {
                return null;
            }
            switch (this.type) {
                case 0: {
                    return new Number[]{((InventoryClickEvent)e).getSlot()};
                }
                case 1: {
                    return new Number[]{((InventoryClickEvent)e).getRawSlot()};
                }
                case 2: {
                    return new Number[]{((InventoryClickEvent)e).getHotbarButton()};
                }
                case 3: {
                    return new Inventory[]{InventoryUtils.getClickedInventory((InventoryClickEvent)e)};
                }
                case 4: {
                    return new InventoryAction[]{((InventoryClickEvent)e).getAction()};
                }
                case 5: {
                    return new ClickType[]{((InventoryClickEvent)e).getClick()};
                }
                case 6: {
                    return new ItemStack[]{((InventoryClickEvent)e).getCursor()};
                }
                case 7: {
                    return new ItemStack[]{((InventoryClickEvent)e).getCurrentItem()};
                }
                case 8: {
                    return new InventoryType.SlotType[]{((InventoryClickEvent)e).getSlotType()};
                }
                case 9: {
                    return new Player[]{(Player)((InventoryClickEvent)e).getWhoClicked()};
                }
                case 10: {
                    return ((InventoryClickEvent)e).getViewers().toArray();
                }
                case 11: {
                    Inventory c = InventoryUtils.getClickedInventory((InventoryClickEvent)e);
                    if (c == null) break;
                    return new String[]{c.getName()};
                }
                case 12: {
                    if (gui == null) break;
                    return new String[]{"" + gui.convertSlot(((InventoryClickEvent)e).getSlot())};
                }
                case 13: {
                    if (gui == null) break;
                    return new GUIInventory[]{gui};
                }
            }
        } else if (e instanceof InventoryCloseEvent && gui != null) {
            switch (this.type) {
                case 3: {
                    return new Inventory[]{((InventoryCloseEvent)e).getInventory()};
                }
                case 9: {
                    return new Player[]{(Player)((InventoryCloseEvent)e).getPlayer()};
                }
                case 10: {
                    return ((InventoryCloseEvent)e).getViewers().toArray();
                }
                case 11: {
                    if (((InventoryCloseEvent)e).getInventory() == null) break;
                    return new String[]{((InventoryCloseEvent)e).getInventory().getName()};
                }
                case 13: {
                    return new GUIInventory[]{gui};
                }
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (e instanceof InventoryClickEvent) {
            if (this.type == 7) {
                this.changer.change((Object[])new Slot[]{new InventorySlot(((InventoryClickEvent)e).getInventory(), ((InventoryClickEvent)e).getSlot())}, delta, mode);
            } else if (this.type == 11) {
                String newName;
                GUIInventory gui = GUIHandler.getInstance().getGUIEvent(e);
                String string = newName = delta != null && delta.length > 0 ? (String)delta[0] : null;
                if (newName != null && gui != null) {
                    gui.changeProperties(newName, 0, null, 0);
                }
            } else {
                CursorSlot cursor = new CursorSlot((Player)((InventoryClickEvent)e).getWhoClicked());
                this.changer.change((Object[])new Slot[]{cursor}, delta, mode);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (ScriptLoader.isCurrentEvent(InventoryCloseEvent.class)) {
            return null;
        }
        if (this.type == 6 || this.type == 7) {
            if (!this.isDelayed) {
                if (this.changer == null) {
                    this.changer = Classes.getExactClassInfo(Slot.class).getChanger();
                }
                return this.changer.acceptChange(mode);
            }
            Skript.error((String)("You can't set the " + this.toString + " when the event is already passed."));
        } else if (this.type == 1) {
            return new Class[]{String.class};
        }
        return null;
    }

    static {
        Registry.newSimple(ExprGUIValue.class, "gui-slot", "gui-raw-slot", "gui-hotbar-slot", "gui-inventory", "gui-inventory-action", "gui-click-(type|action)", "gui-cursor[-item]", "gui-[(clicked|current)-]item", "gui-slot-type", "gui-player", "gui-players", "gui-inventory-name", "gui-slot-id", "gui");
    }
}

