/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions.customenchantments;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.manager.customenchantment.CEnchant;
import com.github.tukenuke.tuske.manager.customenchantment.EnchantConfig;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class ExprMaxLevel
extends SimplePropertyExpression<CEnchant, Number> {
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Nullable
    public Number convert(CEnchant ce) {
        return ce.getEnchant().getMaxLevel();
    }

    protected String getPropertyName() {
        return "max level";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        CEnchant ce = (CEnchant)this.getExpr().getSingle(e);
        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET && delta == null) {
            return;
        }
        if (ce != null) {
            int value = ce.getEnchant().getMaxLevel();
            switch (mode) {
                case SET: {
                    value = ((Number)delta[0]).intValue();
                    break;
                }
                case ADD: {
                    value += ((Number)delta[0]).intValue();
                    break;
                }
                case REMOVE: {
                    value -= ((Number)delta[0]).intValue();
                    break;
                }
            }
            if (value < 1) {
                value = 1;
            } else if (value > 3999) {
                value = 3999;
            }
            ce.getEnchant().setMaxLevel(value);
            EnchantConfig.y.set("Enchantments." + ce.getEnchant().getId() + ".MaxLevel", (Object)value);
            EnchantConfig.save();
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprMaxLevel.class, "max level", "customenchantment");
    }
}

