/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.listeners.OnlineStatusCheck;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Online Time")
@Description(value={"Returns a {{types|Timespan|timespan}} of online time of {{types|Player|player}} or of the server. Only the online time of player can be edited."})
@Examples(value={"command /online:", "\ttrigger:", "\t\tsend \"You're online for %online time of player% and the server is online for %online time of server%\""})
@Since(value="1.0 (player), 1.5.8 (server)")
public class ExprOnlineTime
extends SimplePropertyExpression<Player, Timespan> {
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @Nullable
    public Timespan convert(Player p) {
        if (p == null || !p.isOnline()) {
            return null;
        }
        return new Date(OnlineStatusCheck.getTime(p).longValue()).difference(new Date(System.currentTimeMillis()));
    }

    protected String getPropertyName() {
        return "online time";
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Player p = ((Player[])this.getExpr().getArray(e))[0];
        Long t = 0L;
        if (mode != Changer.ChangeMode.DELETE && mode != Changer.ChangeMode.RESET && delta != null) {
            t = ((Timespan)delta[0]).getMilliSeconds();
        }
        switch (mode) {
            case RESET: 
            case DELETE: 
            case SET: {
                OnlineStatusCheck.setTime(p, System.currentTimeMillis() - t);
                break;
            }
            case ADD: {
                OnlineStatusCheck.setTime(p, OnlineStatusCheck.getTime(p) - t);
                break;
            }
            case REMOVE: {
                if (OnlineStatusCheck.getTime(p) > System.currentTimeMillis() - t) {
                    OnlineStatusCheck.setTime(p, System.currentTimeMillis());
                    break;
                }
                OnlineStatusCheck.setTime(p, OnlineStatusCheck.getTime(p) + t);
                break;
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.REMOVE_ALL) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprOnlineTime.class, "online time", "player");
    }
}

