/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ExprLeatherColor
extends SimpleExpression<Integer> {
    private Expression<?> i;
    private int rgb;

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.i = arg[0].getConvertedExpression(new Class[]{Object.class});
        this.rgb = arg3.mark;
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "leather " + (this.rgb == 0 ? "red" : (this.rgb == 1 ? "green" : "blue")) + " color of " + (this.i instanceof ItemStack ? "item stack" : "color");
    }

    @Nullable
    protected Integer[] get(Event e) {
        Color color = null;
        Object[] array = this.i.getArray(e);
        if (array != null && array.length > 0 && array[0] != null) {
            if (array[0] instanceof ItemStack || array[0] instanceof ItemType) {
                ItemMeta im;
                ItemMeta itemMeta = im = array[0] instanceof ItemStack ? ((ItemStack)array[0]).getItemMeta() : (ItemMeta)((ItemType)array[0]).getItemMeta();
                if (im == null) {
                    im = Bukkit.getItemFactory().getItemMeta(Material.LEATHER_BOOTS);
                }
                if (im instanceof LeatherArmorMeta) {
                    color = ((LeatherArmorMeta)im).getColor();
                }
            } else if (array[0] instanceof ch.njol.skript.util.Color) {
                color = ((ch.njol.skript.util.Color)array[0]).getBukkitColor();
            }
            if (color != null) {
                switch (this.rgb) {
                    case 0: {
                        return new Integer[]{color.getRed()};
                    }
                    case 1: {
                        return new Integer[]{color.getGreen()};
                    }
                    case 2: {
                        return new Integer[]{color.getBlue()};
                    }
                }
            }
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object[] array = this.i.getArray(e);
        if (array != null && array.length > 0 && delta != null && delta.length > 0 && delta[0] != null) {
            for (Object obj : array) {
                ItemMeta im;
                if (obj == null || !(obj instanceof ItemStack) && !(obj instanceof ItemType)) continue;
                ItemMeta itemMeta = im = obj instanceof ItemStack ? ((ItemStack)obj).getItemMeta() : ((ItemType)obj).getRandom().getItemMeta();
                if (im == null) {
                    im = Bukkit.getItemFactory().getItemMeta(Material.LEATHER_BOOTS);
                }
                if (!(im instanceof LeatherArmorMeta)) continue;
                Color color = ((LeatherArmorMeta)im).getColor();
                int value = ((Number)delta[0]).intValue();
                int from = 0;
                switch (this.rgb) {
                    case 0: {
                        from = color.getRed();
                        break;
                    }
                    case 1: {
                        from = color.getBlue();
                        break;
                    }
                    case 2: {
                        from = color.getGreen();
                    }
                }
                switch (mode) {
                    case ADD: {
                        value += from;
                        break;
                    }
                    case REMOVE: {
                        value = from - value;
                        break;
                    }
                }
                if (value < 0) {
                    value = 0;
                } else if (value > 255) {
                    value = 255;
                }
                switch (this.rgb) {
                    case 0: {
                        color = Color.fromRGB((int)value, (int)color.getGreen(), (int)color.getBlue());
                        break;
                    }
                    case 1: {
                        color = Color.fromRGB((int)color.getRed(), (int)value, (int)color.getBlue());
                        break;
                    }
                    case 2: {
                        color = Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)value);
                    }
                }
                ((LeatherArmorMeta)im).setColor(color);
                if (obj instanceof ItemStack) {
                    ((ItemStack)obj).setItemMeta(im);
                    continue;
                }
                ((ItemType)obj).setItemMeta((Object)im);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    static {
        Registry.newProperty(ExprLeatherColor.class, "[leather] (0\u00a6red|1\u00a6green|2\u00a6blue) colo[u]r", "-itemstacks/colors");
    }
}

