/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.events;

import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.events.customevent.InventoryMoveEvent;
import com.github.tukenuke.tuske.util.InventoryUtils;
import com.github.tukenuke.tuske.util.Registry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EvtInventoryMove
extends SelfRegisteringSkriptEvent {
    private static List<Trigger> triggers;
    private static Listener listener;

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "inventory move event";
    }

    public void register(Trigger trigger) {
        triggers.add(trigger);
        if (triggers.size() == 1) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)TuSKe.getInstance());
        }
    }

    public void unregister(Trigger trigger) {
        triggers.remove(trigger);
        if (triggers.size() == 0) {
            this.unregisterAll();
        }
    }

    public void unregisterAll() {
        triggers.clear();
        HandlerList.unregisterAll((Listener)listener);
    }

    public boolean init(Literal<?>[] arg0, int arg1, SkriptParser.ParseResult arg2) {
        return true;
    }

    static {
        Registry.newEvent(EvtInventoryMove.class, InventoryMoveEvent.class, "Inventory move", "inventory move");
        triggers = new ArrayList<Trigger>();
        listener = new Listener(){

            @EventHandler
            public void onEvent(InventoryClickEvent e) {
                if (!e.isCancelled() && (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY) || e.getAction().equals((Object)InventoryAction.HOTBAR_MOVE_AND_READD)) && (e.getClick().equals((Object)ClickType.SHIFT_LEFT) || e.getClick().equals((Object)ClickType.SHIFT_RIGHT) || e.getClick().equals((Object)ClickType.NUMBER_KEY))) {
                    int slotFrom;
                    int slotTo;
                    Inventory invFrom;
                    Inventory invTo;
                    if (!(e.getInventory().getType().equals((Object)InventoryType.CHEST) || e.getInventory().getType().equals((Object)InventoryType.DISPENSER) || e.getInventory().getType().equals((Object)InventoryType.DISPENSER) || e.getInventory().getType().equals((Object)InventoryType.HOPPER) || e.getInventory().getType().equals((Object)InventoryType.ENDER_CHEST))) {
                        return;
                    }
                    Inventory click = InventoryUtils.getClickedInventory(e);
                    ItemStack i = e.getCurrentItem();
                    if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                        invTo = e.getWhoClicked().getInventory().equals(click) ? e.getInventory() : e.getWhoClicked().getInventory();
                        invFrom = click;
                        slotTo = invTo.equals(e.getInventory()) ? InventoryUtils.getSlotTo(invTo, e.getCurrentItem()) : InventoryUtils.getInvertedSlotTo(invTo, e.getCurrentItem());
                        slotFrom = e.getSlot();
                    } else {
                        if (e.getWhoClicked().getInventory().equals(click)) {
                            return;
                        }
                        invTo = click.getItem(e.getSlot()) != null ? e.getWhoClicked().getInventory() : e.getInventory();
                        invFrom = invTo.equals(click) ? e.getWhoClicked().getInventory() : e.getInventory();
                        slotTo = invTo.equals(e.getInventory()) ? e.getSlot() : e.getHotbarButton();
                        slotFrom = invTo.equals(e.getInventory()) ? e.getHotbarButton() : e.getSlot();
                        i = invFrom.getItem(slotFrom);
                    }
                    if (slotTo < 0) {
                        return;
                    }
                    InventoryMoveEvent im = new InventoryMoveEvent((Player)e.getWhoClicked(), i, e.getClick().toString().toLowerCase().replaceAll("_", " "), invFrom, invTo, slotFrom, slotTo);
                    SkriptEventHandler.logEventStart((Event)im);
                    for (Trigger t : triggers) {
                        SkriptEventHandler.logTriggerStart((Trigger)t);
                        t.execute((Event)im);
                        SkriptEventHandler.logTriggerEnd((Trigger)t);
                    }
                    e.setCancelled(im.isCancelled());
                    SkriptEventHandler.logEventEnd();
                }
            }
        };
    }
}

